<style>
    #spinner-add-order {
        position: absolute;
        width: 100%;
        height: 100%;
        background-color: #ee8f23;
        z-index: 2;
        text-align: center;
        /* top: 50%; */
        padding-top: 80%;
        font-size: 40px;
        color: white;
    }

    .div_selected_service {
        border: 2.5px solid red;
    }
</style>
<!-- <br> -->
<input type="hidden" id="apaczka-order-service-id">
<!-- <br> -->
<input type="hidden" id="apaczka-order-status">
<!-- <br> -->
<input type="hidden" id="apaczka-order-package">
<!-- <br> -->
<!-- </br> -->
<script src="https://mapa.apaczka.pl/client/apaczka.map.js"></script>
<script>
    $(document).ready(function() {

        $('#div_receiver_foreign_address_id').hide();
        isCourierType();
        loadPackageTemplates();
        loadSenderTemplates();

        {if isset($apaczka_order['apaczka_id']) }

            $.ajax({
                type: "POST",
                dataType: "JSON",
                url: '{$ajax}',
                data: {
                    apaczkaGet: true,
                    apaczka_id: {$apaczka_order['apaczka_id']},
                    APACZKA8_PS_SECRET_KEY: '{$APACZKA8_PS_SECRET_KEY}'
                },
                success: function(data) {

                    console.log(data);

                    if (data.status == "200") {

                        $('#apaczka-order-status').val(data.response.order.status);
                        $('#apaczka-order-service-id').val(data.response.order.service_id);
                        $('#apaczka-order-package').val(data.response.order.shipments[0]
                            .shipment_type_code);

                        $('#apaczka-order').show();
                        $('#apaczka-service').hide();

                        showSuccessAlert("Paczka o numerze " + data.response.order.waybill_number +
                            " została utworzona poprawnie.");

                        $('#success-link-apaczka-number').attr("href",
                            'https://www.apaczka.pl/sledz-przesylke/?waybill=' + data.response.order
                            .waybill_number);

                        $('#success-link-apaczka-number').text(data.response.order.waybill_number);

                        $('#success-link-apaczka-id').attr("href",
                            'https://panel.apaczka.pl/zlecenia/' + data.response.order
                            .id);

                        $('#success-link-apaczka-id').text(data.response.order.id);
                        $('#apaczka-order-id').val(data.response.order.id);
                    }

                    if (data.status == "400") {
                        showDangerAlert(data.message);
                    }
                },
                error: function(xhr, status, error) {
                    console.error(xhr);
                }
            });
        {/if}
    });

    function choseDefaultPoint(sender = false, reciver = false) {

        var suplier = $('#selected_supplier').val();
        var suplierName = "";

        if (suplier == 'dhl') {
            suplierName = 'DHL_PARCEL';
        }
        if (suplier == 'dpd') {
            suplierName = 'DPD';
        }
        if (suplier == 'inpost') {
            suplierName = 'INPOST';
        }
        if (suplier == 'ups') {
            suplierName = 'UPS';
        }
        if (suplier == 'poczta') {
            suplierName = 'POCZTA';
        }
        if (suplier == 'pwr') {
            suplierName = 'PWR';
        }

        var APP_ID = $('#APP_ID').val();

        var countryCode = "PL";
        if (reciver) {
            countryCode = $('#receiver_country').val();
        }

        var apaczkaMap = new ApaczkaMap({
            app_id: APP_ID,
            countryCode: countryCode,
            onChange: function(record) {
                if (record) {
                    if (sender) {
                        // alert('Wybrano: ' + record.foreign_access_point_id);
                        $('#sender_foreign_address_id').val(record.foreign_access_point_id);
                    }
                    if (reciver) {
                        // alert('Wybrano: ' + record.foreign_access_point_id);
                        $('#receiver_foreign_address_id').val(record.foreign_access_point_id);
                    }
                }
            }
        });

        apaczkaMap.setFilterSupplierAllowed(
            [suplierName],
            [suplierName]
        );

        if (reciver) {
            apaczkaMap.show({
                address: {
                    street: $('#receiver_street').val(),
                    city: $('#receiver_city').val(),
                }
            });
        }
        if (sender) {
            apaczkaMap.show({});
        }
        

    }

    function isCourierType(fromSelect = false) {

        if (fromSelect) {
            $('#button-apaczka-add-order').hide();
            $('#apaczka-services').empty();
        }

        if ($('#type').val() == "COURIER") {
            $('#div_sender_point').hide();
            $('#date_text').text("Data odbioru *");
            $('#hours_from_text').text("Godziny odbioru od *");
            $('#hours_to_text').text("Godziny odbioru do *");

            $('#sender_foreign_address_id').val('');
        } else {
            $('#date_text').text("Data odbioru");
            $('#hours_from_text').text("Godziny odbioru od");
            $('#hours_to_text').text("Godziny odbioru do");
        }
    }

    function validateApaczkaForm() {

        if (
            $('#type').val() == "COURIER" &&
            $('#date').val() == "" &&
            $('#hours_from').val() == "" &&
            $('#hours_to').val() == ""
        ) {
            return false;
        }

        if ($('#type').val() == "" || $('#weight').val() == "" || $('#content').val() == "" ||
            $('#dimension1').val() == "" || $('#dimension2').val() == "" ||
            $('#dimension3').val() == "" || $('#sender_bank_account_number').val() == "" ||
            $('#sender_phone').val() == "" || $('#sender_email').val() == "" ||
            $('#sender_postal_code').val() == "" ||
            $('#sender_apartment_no').val() == "" || $('#sender_apartment_no').val() == "" ||
            $('#sender_name').val() == "" || $('#receiver_name').val() == "" ||
            $('#receiver_street').val() == "" ||
            $('#receiver_postal_code').val() == "" ||
            $('#receiver_city').val() == "" || $('#receiver_contact_person').val() == "" ||
            $('#receiver_email').val() == "" || $('#receiver_phone').val() == ""
        ) {

            return false;
        }

        return true;
    }

    function getApaczkaPdf() {

        $.ajax({
            type: "POST",
            dataType: "JSON",
            url: '{$ajax}',
            data: {
                getApaczkaPdf: true,
                apaczka_order_id: $('#apaczka-order-id').val(),
                APACZKA8_PS_SECRET_KEY: '{$APACZKA8_PS_SECRET_KEY}'
            },
            success: function(data) {
                console.log(data);

                if (data.status == '200') {

                    var base64String = 'data:application/pdf;base64,' + data.response.waybill;

                    const downloadLink = document.createElement("a");

                    downloadLink.href = base64String;

                    downloadLink.download = $('#apaczka-order-id').val() + ".pdf";

                    downloadLink.click();

                }
            },
            error: function(xhr, status, error) {
                console.error(xhr);
            }
        });
    }

    function isPaczkaOrLetter(package, service_id = 0) {

        if (service_id == "200") {
            return false;
        }

        if (package == "PACZKA") {
            return true;
        }
        if (package == "LIST") {
            return true;
        }

        return false;
    }

    function isPaleta(package) {

        if (package == "PALETA") {
            return true;
        }
        if (package == "POLPALETA") {
            return true;
        }
        if (package == "PALETA_PRZEMYSLOWA") {
            return true;
        }
        if (package == "PALETA_PRZEMYSLOWA_B") {
            return true;
        }

        return false;
    }

    function canDelete() {

        var apaczka_order_status = $('#apaczka-order-status').val();
        var apaczka_order_package = $('#apaczka-order-package').val();
        var apaczka_order_service_id = $('#apaczka-order-service-id').val();

        if (isPaczkaOrLetter(apaczka_order_package, apaczka_order_service_id)) {
            return true;
        }

        var exceptionsForPallets = ["151", "82", "21"];

        if (exceptionsForPallets.includes(apaczka_order_service_id) && isPaleta(apaczka_order_package)) {
            return true;
        }

        if (apaczka_order_status == "CANCELLED" && isPaleta(apaczka_order_package)) {
            return true;
        }

        return false;
    }

    function deleteApaczkaOrder() {

        $('#alert-danger-delete').hide();
        $('#apaczka-alert-success').hide();
        $('.apaczka-spinner').show();
        $('#button-apaczka-add-order').hide();

        if (canDelete()) {

            $.ajax({
                type: "POST",
                dataType: "JSON",
                url: '{$ajax}',
                data: {
                    apaczkaDelete: true,
                    apaczka_order_id: $('#apaczka-order-id').val(),
                    APACZKA8_PS_SECRET_KEY: '{$APACZKA8_PS_SECRET_KEY}'
                },
                success: function(data) {
                    console.log(data);

                    if (data.status == '200' || data.status == '400') {
                        //if (data.status == '200') {

                        $('#apaczka-order').hide();
                        $('#apaczka-service').show();
                    }

                    $('.apaczka-spinner').hide();
                },
                error: function(xhr, status, error) {
                    console.error(xhr);
                }
            });
        } else {
            $('#alert-danger-delete').show();
            $('.apaczka-spinner').hide();
        }
    }

    function showReciverPoint(point_to_point = 0, door_to_point = 0) {

        if (point_to_point == "1" || door_to_point == "1") {
            $('#send_reciver_point').val("1");
            $('#div_receiver_foreign_address_id').show();
        }
    }

    function showSenderPoint(point_to_point = 0, point_to_door = 0, service_id = 0) {

        var exceptionsDontShowSenderPointServicesId = [1, 2, 3, 4, 5, 21, 24, 25, 28, 82];

        if (exceptionsDontShowSenderPointServicesId.includes(service_id)) {
            return false;
        }

        if (point_to_point == 1 || point_to_door == 1) {

            return true;
        }

        return false;
    }

    function selectedService(service_id, supplier = "", point_to_point = 0, point_to_door = 0, door_to_point = 0) {

        console.log("service_id: " + service_id);
        console.log("point_to_point: " + point_to_point);
        console.log("door_to_point: " + door_to_point);
        console.log("point_to_door: " + point_to_door);

        $('#send_reciver_point').val("0");
        $('#div_receiver_foreign_address_id').hide();
        $('#button-apaczka-add-order').show();

        $('#div_sender_point').hide();
        $('#selected_service_id').val(service_id);
        $('#selected_supplier').val(supplier);

        if (supplier == "dhl" && showSenderPoint(point_to_point, point_to_door, service_id)) {
            $('#div_sender_point').show();
            $('#txt_sender_supplier_name').text("(DHL)");
            $('#sender_foreign_address_id').val(
                $('#APACZKA8_DEFAULT_POINT_DHL').val()
            );
        }

        if (supplier == "dpd" && showSenderPoint(point_to_point, point_to_door, service_id)) {
            $('#div_sender_point').show();
            $('#txt_sender_supplier_name').text("(DPD)");
            $('#sender_foreign_address_id').val(
                $('#APACZKA8_DEFAULT_POINT_DPD').val()
            );
        }
        //&& service_id != 42
        if (supplier == "inpost" && showSenderPoint(point_to_point, point_to_door, service_id)) {
            $('#div_sender_point').show();
            $('#txt_sender_supplier_name').text("(INPOST)");
            $('#sender_foreign_address_id').val(
                $('#APACZKA8_DEFAULT_POINT_INPOST').val()
            );
        }

        if (supplier == "ups" && showSenderPoint(point_to_point, point_to_door, service_id)) {
            $('#div_sender_point').show();
            $('#txt_sender_supplier_name').text("(UPS)");
            $('#sender_foreign_address_id').val(
                $('#APACZKA8_DEFAULT_POINT_UPS').val()
            );
        }

        if (supplier == "poczta" && showSenderPoint(point_to_point, point_to_door, service_id)) {
            $('#div_sender_point').show();
            $('#txt_sender_supplier_name').text("(POCZTA)");
            $('#sender_foreign_address_id').val(
                $('#APACZKA8_DEFAULT_POINT_POCZTA').val()
            );
        }

        isCourierType();
        if (showSenderPoint(point_to_point, point_to_door, service_id)) {
            $('#send_reciver_point').val("1");
        }
        showReciverPoint(point_to_point, door_to_point);

        $(".div_selected_service").removeClass("div_selected_service");

        $('#service_id_' + service_id).addClass('div_selected_service');
    }

    function addApaczkaOrder() {

        var service_id = $('#selected_service_id').val();
        var supplier = $('#selected_supplier').val(); //.toLowerCase()
        var receiver_apaczka_supplier = $('#receiver_apaczka_supplier').val();

        $('#spinner-add-order').show();
        $('#apaczka-alert-danger').hide();
        $('#apaczka-services').empty();

        if (validateApaczkaForm()) {

            var receiver_foreign_address_id = $('#receiver_foreign_address_id').val();

            if ($('#send_reciver_point').val() == "0") {
                receiver_foreign_address_id = "";
            }

            $.ajax({
                type: "POST",
                dataType: "JSON",
                url: '{$ajax}',
                data: {
                    service_id: service_id,
                    ps_id: {$order->id},
                    //nadawca
                    sender_name: $('#sender_name').val(),
                    sender_street: $('#sender_street').val(),
                    sender_apartment_no: $('#sender_apartment_no').val(),
                    sender_apartment_number: $('#sender_apartment_number').val(),
                    sender_postal_code: $('#sender_postal_code').val(),
                    sender_city: $('#sender_city').val(),
                    sender_is_residential: $('#sender_is_residential').val(),
                    sender_contact_person: $('#sender_contact_person').val(),
                    sender_email: $('#sender_email').val(),
                    sender_phone: $('#sender_phone').val(),
                    sender_foreign_address_id: $('#sender_foreign_address_id').val(),
                    //odbiorca
                    receiver_name: $('#receiver_name').val(),
                    receiver_country: $('#receiver_country').val(),
                    receiver_street: $('#receiver_street').val(),
                    receiver_apartment_no: $('#receiver_apartment_no').val(),
                    receiver_apartment_number: $('#receiver_apartment_number').val(),
                    receiver_postal_code: $('#receiver_postal_code').val(),
                    receiver_city: $('#receiver_city').val(),
                    receiver_is_residential: $('#receiver_is_residential').val(),
                    receiver_contact_person: $('#receiver_contact_person').val(),
                    receiver_email: $('#receiver_email').val(),
                    receiver_phone: $('#receiver_phone').val(),
                    supplier: supplier,
                    receiver_apaczka_supplier: $('#receiver_apaczka_supplier').val(),
                    receiver_foreign_address_id: receiver_foreign_address_id,
                    //przesylka
                    dimension1: $('#dimension1').val(),
                    dimension2: $('#dimension2').val(),
                    dimension3: $('#dimension3').val(),
                    shipment_type_code: $('#shipment_type_code').val(),
                    weight: $('#weight').val(),
                    content: $('#content').val(),
                    value: $('#value').val() * 100,
                    type: $('#type').val(),
                    date: $('#date').val(),
                    hours_from: $('#hours_from').val(),
                    hours_to: $('#hours_to').val(),
                    cod: $('#cod').val() * 100,
                    sender_bank_account_number: $('#sender_bank_account_number').val(),
                    custom_shipping: $('#custom_shipping').val(),
                    APACZKA8_PS_SECRET_KEY: '{$APACZKA8_PS_SECRET_KEY}'
                },
                success: function(data) {

                    console.log(data);

                    if (data.status == "200") {

                        $('#apaczka-order-status').val(data.response.order.status);
                        $('#apaczka-order-service-id').val(data.response.order.service_id);
                        $('#apaczka-order-package').val($('#shipment_type_code').val());

                        $('#apaczka-order').show();
                        $('#apaczka-service').hide();

                        showSuccessAlert("Paczka o numerze " + data.response.order.waybill_number +
                            " została utworzona poprawnie.");

                        $('#success-link-apaczka-number').attr("href",
                            'https://www.apaczka.pl/sledz-przesylke/?waybill=' + data.response.order
                            .waybill_number);

                        $('#success-link-apaczka-number').text(data.response.order.waybill_number);

                        $('#success-link-apaczka-id').attr("href",
                            'https://panel.apaczka.pl/zlecenia/' + data.response.order
                            .id);

                        $('#success-link-apaczka-id').text(data.response.order.id);
                        $('#apaczka-order-id').val(data.response.order.id);
                    }

                    if (data.status == "400") {
                        showDangerAlert(data.message);
                    }
                    $('#spinner-add-order').hide();
                },
                error: function(xhr, status, error) {
                    console.error(xhr);
                }
            });
        } else {
            showDangerAlert('Nie dodałem zamówienia coś poszło nie tak');
            $('#spinner-add-order').hide();
        }


    }

    function getApaczkaServices() {

        $('#div_sender_point').hide();
        $('#button-apaczka-add-order').hide();

        $('#txt_sender_supplier_name').text("");
        $('#sender_foreign_address_id').val("");

        $('.apaczka-spinner').show();

        $('#apaczka-alert-danger').hide();
        $('#apaczka-services').empty();

        if (validateApaczkaForm()) {

            $.ajax({
                type: "POST",
                dataType: "JSON",
                url: '{$ajax}',
                data: {
                    //nadawca
                    sender_name: $('#sender_name').val(),
                    sender_street: $('#sender_street').val(),
                    sender_apartment_no: $('#sender_apartment_no').val(),
                    sender_apartment_number: $('#sender_apartment_number').val(),
                    sender_postal_code: $('#sender_postal_code').val(),
                    sender_city: $('#sender_city').val(),
                    sender_is_residential: $('#sender_is_residential').val(),
                    sender_contact_person: $('#sender_contact_person').val(),
                    sender_email: $('#sender_email').val(),
                    sender_phone: $('#sender_phone').val(),
                    sender_foreign_address_id: $('#sender_foreign_address_id').val(),
                    //odbiorca
                    receiver_country: $('#receiver_country').val(),
                    receiver_name: $('#receiver_name').val(),
                    receiver_street: $('#receiver_street').val(),
                    receiver_apartment_no: $('#receiver_apartment_no').val(),
                    receiver_apartment_number: $('#receiver_apartment_number').val(),
                    receiver_postal_code: $('#receiver_postal_code').val(),
                    receiver_city: $('#receiver_city').val(),
                    receiver_is_residential: $('#receiver_is_residential').val(),
                    receiver_contact_person: $('#receiver_contact_person').val(),
                    receiver_email: $('#receiver_email').val(),
                    receiver_phone: $('#receiver_phone').val(),
                    receiver_foreign_address_id: $('#receiver_foreign_address_id').val(),
                    //przesylka
                    dimension1: $('#dimension1').val(),
                    dimension2: $('#dimension2').val(),
                    dimension3: $('#dimension3').val(),
                    shipment_type_code: $('#shipment_type_code').val(),
                    weight: $('#weight').val(),
                    content: $('#content').val(),
                    value: $('#value').val() * 100,
                    type: $('#type').val(),
                    date: $('#date').val(),
                    hours_from: $('#hours_from').val(),
                    hours_to: $('#hours_to').val(),
                    cod: $('#cod').val() * 100,
                    sender_bank_account_number: $('#sender_bank_account_number').val(),
                    custom_shipping: $('#custom_shipping').val(),
                    APACZKA8_PS_SECRET_KEY: '{$APACZKA8_PS_SECRET_KEY}'
                },
                success: function(data) {

                    data.forEach(function(row) {
                        //point_to_point = 0, point_to_door = 0
                        $('#apaczka-services').append(
                            '<div id="service_id_' + row.service_id +
                            '" onclick="selectedService(' + row.service_id +
                            ", '" + row.supplier + "'" + ',' + row.point_to_point + ',' + row
                            .point_to_door + ',' + row.door_to_point +
                            ')" class="card apaczka-order-service text-center mr-3 cursor-pointer" style="width: 10rem;"><img class="card-img-top" src="https://panel.apaczka.pl/public/img/services/' +
                            row.supplier +
                            '.png"><div class="card-body" style="height: 6rem;"><p class="card-text">' +
                            row.name + '</p></div><div class="card-footer">' + row.price_gross +
                            ' PLN</div></div>'
                        );
                    });

                    $('.apaczka-spinner').hide();
                },
                error: function(xhr, status, error) {
                    console.error(xhr);
                }
            });
        } else {
            showDangerAlert('Uzupełnij wszystkie pola w formularzu z *');
            $('.apaczka-spinner').hide();
        }


    }

    function showSuccessAlert(mesage = "success alert") {

        $('#apaczka-mesage2-alert').text(mesage);
        $('#apaczka-alert-success').show();
    }

    function showDangerAlert(mesage = "Danger alert") {

        $('#apaczka-mesage-alert').text(mesage);
        $('#apaczka-alert-danger').show();
    }

    function changeTypeOfDelivery() {

        $('#button-apaczka-add-order').hide();

        var defaultDimension1 = '{$APACZKA8_DIMENSION1}';
        var defaultDimension2 = '{$APACZKA8_DIMENSION2}';
        var defaultDimension3 = '{$APACZKA8_DIMENSION3}';
        var defaultWeight = '{$APACZKA8_WEIGHT}';

        if ($('#type_of_delivery').val() == "standard") {

            $('#shipment_type_code').val('PACZKA');
            $('#dimension1').val(defaultDimension1);
            $('#dimension2').val(defaultDimension2);
            $('#dimension3').val(defaultDimension3);
            $('#weight').val(defaultWeight);
        }
        if ($('#type_of_delivery').val() == "letter") {

            $('#shipment_type_code').val('LIST');
            $('#dimension1').val("35");
            $('#dimension2').val("25");
            $('#dimension3').val("5");
            $('#weight').val("1");
        }
        if ($('#type_of_delivery').val() == "palette_120_80") {

            $('#shipment_type_code').val('PALETA');
            $('#dimension1').val("120");
            $('#dimension2').val("80");
            $('#dimension3').val(defaultDimension3);
            $('#weight').val(defaultWeight);
            $('#type').val('COURIER').trigger('change')
        }
        if ($('#type_of_delivery').val() == "palette_60_40") {

            $('#shipment_type_code').val('POLPALETA');
            $('#dimension1').val("60");
            $('#dimension2').val("40");
            $('#dimension3').val(defaultDimension3);
            $('#weight').val(defaultWeight);
            $('#type').val('COURIER').trigger('change')
        }
        if ($('#type_of_delivery').val() == "palette_80_60") {

            $('#shipment_type_code').val('POLPALETA');
            $('#dimension1').val("80");
            $('#dimension2').val("60");
            $('#dimension3').val(defaultDimension3);
            $('#weight').val(defaultWeight);
            $('#type').val('COURIER').trigger('change')
        }
        if ($('#type_of_delivery').val() == "palette_120_100") {

            $('#shipment_type_code').val('PALETA_PRZEMYSLOWA');
            $('#dimension1').val("120");
            $('#dimension2').val("100");
            $('#dimension3').val(defaultDimension3);
            $('#weight').val(defaultWeight);
            $('#type').val('COURIER').trigger('change')
        }
        if ($('#type_of_delivery').val() == "palette_120_120") {

            $('#shipment_type_code').val('PALETA_PRZEMYSLOWA_B');
            $('#dimension1').val("120");
            $('#dimension2').val("120");
            $('#dimension3').val(defaultDimension3);
            $('#weight').val(defaultWeight);
            $('#type').val('COURIER').trigger('change')
        }
    }
</script>

<div class="card mt-2" id="apaczka-order" style="display: none;">
    <div class="card-header">
        <h3 class="card-header-title">Przesyłki Apaczka.pl</h3>
    </div>
    <div class="card-body">

        <p class="text-danger" id="alert-danger-delete" style="display: none; font-size: 20px;"><b>Wysyłkę można
                anulować tylko na stronie Apaczka.pl poprzez formularz kontaktowy:<br>
                Nadania i Doręczenia -> Anulowanie zlecenia przesyłki paletowej i GLS.
                <br>Usługa anulowania może wiązać się z dodatkową opłatą.</b></p>

        <div class="row mb-2">
            <div class="col-12"><strong>Twoje zamówienie zostało złożone na apaczka.pl.</strong></div>
        </div>
        <div class="row">
            <div class="col-12">Numer przesyłki to: <a id="success-link-apaczka-number" href="" target="_blank"></a>
            </div>
        </div>
        <div class="row">
            <div class="col-12">Numer zlecenia Apaczka.pl to: <a id="success-link-apaczka-id" href=""
                    target="_blank"></a></div>
        </div>
        <div class="row mt-2">
            <div class="col-12">
                <a onclick="getApaczkaPdf()" class="btn btn-primary">Pobierz list
                    przewozowy</a>
                <input type="hidden" id="apaczka-order-id">
                <a class="btn btn-danger" onclick="deleteApaczkaOrder()">Anuluj przesyłkę <div
                        class="apaczka-spinner spinner-border text-light"
                        style="width: 1rem; height: 1rem; display: none;"></div></a>
            </div>
        </div>
    </div>
</div>

<div class="card mt-2" id="apaczka-service">

    <div id="spinner-add-order" style="display: none;">
        <div class="spinner-border text-light"></div>
    </div>

    <div class="card-header">
        <h3 class="card-header-title">
            Apaczka
        </h3>
    </div>
    <div class="card-body">

        <div class="row">
            <div class="col-md-6">
                <h2>Nadawca</h2>
                <form>

                    <script>
                        function loadDefaultSenderTemplate() {

                            $('#sender_name').val('{$APACZKA8_NAME}');
                            $('#sender_street').val('{$APACZKA8_STREET}');
                            $('#sender_apartment_no').val('{$APACZKA8_APARTMENT_NO}');
                            $('#sender_apartment_number').val('{$APACZKA8_APARTMENT_NUMBER}');
                            $('#sender_postal_code').val('{$APACZKA8_POSTAL_CODE}');
                            $('#sender_city').val('{$APACZKA8_CITY}');
                            $('#sender_contact_person').val('{$APACZKA8_CONTACT_PERSON}');
                            $('#sender_email').val('{$APACZKA8_EMAIL}');
                            $('#sender_phone').val('{$APACZKA8_PHONE}');
                            $('#sender_bank_account_number').val('{$APACZKA8_BANK_ACCOUNT_NUMBER}');
                        }

                        function loadSenderTemplate() {

                            $('#delete_alert_sender_templates').hide();

                            if ($('#sender_templates').val() == "0") {
                                $('#delete_button_sender_templates').prop('disabled', true);
                                loadDefaultSenderTemplate();
                            } else {

                                $('#delete_button_sender_templates').prop('disabled', false);

                                $.ajax({
                                    type: "POST",
                                    dataType: "JSON",
                                    url: '{$ajax}',
                                    data: {
                                        sender_templates: 'load',
                                        templateName: $('#sender_templates').val(),
                                        APACZKA8_PS_SECRET_KEY: '{$APACZKA8_PS_SECRET_KEY}'
                                    },
                                    success: function(data) {

                                        var template = JSON.parse(data.template);

                                        $('#sender_name').val(template.sender_name);
                                        $('#sender_street').val(template.sender_street);
                                        $('#sender_apartment_no').val(template.sender_apartment_no);
                                        $('#sender_apartment_number').val(template.sender_apartment_number);
                                        $('#sender_postal_code').val(template.sender_postal_code);
                                        $('#sender_city').val(template.sender_city);
                                        $('#sender_contact_person').val(template.sender_contact_person);
                                        $('#sender_email').val(template.sender_email);
                                        $('#sender_phone').val(template.sender_phone);
                                        $('#sender_bank_account_number').val(template
                                            .sender_bank_account_number);
                                    },
                                    error: function(xhr, status, error) {
                                        console.error(xhr);
                                    }
                                });
                            }
                        }

                        function loadSenderTemplates(showDeleteAlert = true) {

                            if (showDeleteAlert) {
                                $('#delete_alert_sender_templates').hide();
                            }
                            $('#sender_templates').empty();
                            $('#sender_templates').append('<option value="0">Domyślny</option>');

                            $.ajax({
                                type: "POST",
                                dataType: "JSON",
                                url: '{$ajax}',
                                data: {
                                    sender_templates: 'loadAll',
                                    APACZKA8_PS_SECRET_KEY: '{$APACZKA8_PS_SECRET_KEY}'
                                },
                                success: function(data) {

                                    data.forEach(function(row) {
                                        $('#sender_templates').append('<option value="' + row.name +
                                            '">' + row.name + '</option>');
                                    });

                                },
                                error: function(xhr, status, error) {
                                    console.error(xhr);
                                }
                            });
                        }

                        function addSenderTemplate() {

                            $('#delete_alert_sender_templates').hide();
                            $('#alert-danger-sender').hide();
                            $('#alert-success-sender').hide();

                            if ($('#sender_template_name').val() == "") {
                                $('#alert-danger-sender').show();
                            } else {

                                $.ajax({
                                    type: "POST",
                                    dataType: "JSON",
                                    url: '{$ajax}',
                                    data: {
                                        sender_templates: 'add',
                                        templateName: $('#sender_template_name').val(),
                                        template: {
                                            sender_name: $('#sender_name').val(),
                                            sender_street: $('#sender_street').val(),
                                            sender_apartment_no: $('#sender_apartment_no').val(),
                                            sender_apartment_number: $('#sender_apartment_number').val(),
                                            sender_postal_code: $('#sender_postal_code').val(),
                                            sender_city: $('#sender_city').val(),
                                            sender_contact_person: $('#sender_contact_person').val(),
                                            sender_email: $('#sender_email').val(),
                                            sender_phone: $('#sender_phone').val(),
                                            sender_bank_account_number: $('#sender_bank_account_number').val(),
                                        },
                                        APACZKA8_PS_SECRET_KEY: '{$APACZKA8_PS_SECRET_KEY}'
                                    },
                                    success: function(data) {

                                        loadSenderTemplates();
                                        $('#alert-success-sender').show();
                                        $('#sender_template_name').val('');
                                    },
                                    error: function(xhr, status, error) {
                                        console.error(xhr);
                                    }
                                });
                            }
                        }

                        function deleteSenderTemplate() {

                            if ($('#sender_templates').val() != "0") {

                                $('#delete_button_sender_templates').prop('disabled', true);

                                $.ajax({
                                    type: "POST",
                                    dataType: "JSON",
                                    url: '{$ajax}',
                                    data: {
                                        sender_templates: 'delete',
                                        templateName: $('#sender_templates').val(),
                                        APACZKA8_PS_SECRET_KEY: '{$APACZKA8_PS_SECRET_KEY}'
                                    },
                                    success: function(data) {

                                        if (data.status) {
                                            $('#delete_alert_sender_templates').show();
                                            loadSenderTemplates(false);
                                            loadDefaultSenderTemplate();
                                        }
                                    },
                                    error: function(xhr, status, error) {
                                        console.error(xhr);
                                    }
                                });
                            }
                        }

                        function changeSenderTemplateName() {

                            var templateName = $('#sender_name').val();
                            var allSenderTemplates = [];

                            $("#sender_templates").each(function() {
                                allSenderTemplates.push($(this).val());
                            });

                            for (var i = 0; i < allSenderTemplates.length; i++) {
                                if (allSenderTemplates[i] == templateName) {
                                    templateName = templateName + "_" + i;
                                }
                            }

                            $('#sender_template_name').val(templateName);
                        }
                    </script>

                    <div class="input-group mb-3">

                        <select onchange="loadSenderTemplate();" class="form-control" id="sender_templates">
                        </select>
                        <div class="input-group-append">
                            <button class="btn btn-danger" type="button" onclick="deleteSenderTemplate();"
                                id="delete_button_sender_templates" disabled>Usuń szablon</button>
                        </div>
                    </div>

                    <p class="text-success" id="delete_alert_sender_templates" style="display: none;">Szablon usunięty!
                    </p>

                    <div class="form-group">
                        <label for="sender_name">Nazwa firmy / Imię i nazwisko *</label>
                        <input onchange="changeSenderTemplateName()" type="text" class="form-control" id="sender_name"
                            name="sender_name" value="{$APACZKA8_NAME}">
                    </div>

                    <div class="form-group">
                        <label for="sender_is_residential">Typ adresu</label>
                        <select class="form-control" id="sender_is_residential">
                            <option value="0">Firmowy</option>
                            <option value="1">Prywatny</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="sender_street">Ulica *</label>
                        <input type="text" class="form-control" id="sender_street" name="sender_street"
                            value="{$APACZKA8_STREET}">
                    </div>

                    <div class="form-group">
                        <label for="sender_apartment_no">Nr lokalu *</label>
                        <input type="text" class="form-control" id="sender_apartment_no" name="sender_apartment_no"
                            value="{$APACZKA8_APARTMENT_NO}">
                    </div>

                    <div class="form-group">
                        <label for="sender_apartment_number">Numer mieszkania</label>
                        <input type="text" class="form-control" id="sender_apartment_number"
                            name="sender_apartment_number" value="{$APACZKA8_APARTMENT_NUMBER}">
                    </div>

                    <div class="form-group">
                        <label for="sender_postal_code">Kod pocztowy *</label>
                        <input type="text" class="form-control" id="sender_postal_code" name="sender_postal_code"
                            value="{$APACZKA8_POSTAL_CODE}">
                    </div>

                    <div class="form-group">
                        <label for="sender_city">Miasto *</label>
                        <input type="text" class="form-control" id="sender_city" name="sender_city"
                            value="{$APACZKA8_CITY}">
                    </div>

                    <div class="form-group">
                        <label for="sender_contact_person">Osoba kontaktowa *</label>
                        <input type="text" class="form-control" id="sender_contact_person" name="sender_contact_person"
                            value="{$APACZKA8_CONTACT_PERSON}">
                    </div>

                    <div class="form-group">
                        <label for="sender_email">E-mail *</label>
                        <input type="text" class="form-control" id="sender_email" name="sender_email"
                            value="{$APACZKA8_EMAIL}">
                    </div>

                    <div class="form-group">
                        <label for="sender_phone">Telefon *</label>
                        <input type="text" class="form-control" id="sender_phone" name="sender_phone"
                            value="{$APACZKA8_PHONE}">
                    </div>

                    <div class="form-group">
                        <label for="sender_bank_account_number">Nr konta bankowego *</label>
                        <input type="text" class="form-control" id="sender_bank_account_number"
                            name="sender_bank_account_number" value="{$APACZKA8_BANK_ACCOUNT_NUMBER}">
                    </div>

                    <div class="input-group mb-3">
                        <input type="text" class="form-control" id="sender_template_name"
                            placeholder="Nazwa szablonu przesyłki" aria-label="Nazwa szablonu przesyłki"
                            aria-describedby="basic-addon2">
                        <div class="input-group-append">
                            <button class="btn btn-primary" type="button" onclick="addSenderTemplate();">Zapisz
                                szablon</button>
                        </div>
                    </div>

                    <p class="text-danger" id="alert-danger-sender" style="display: none;">Pole nazwa szablonu jest
                        puste!</p>
                    <p class="text-success" id="alert-success-sender" style="display: none;">Szablon dodany poprawnie!
                    </p>
                </form>
                <h2>Przesyłka</h2>
                <form>
                    <script>
                        function loadDefaultPackageTemplate() {

                            $('#type_of_delivery').val('standard');
                            $('#custom_shipping').val('0');
                            $('#dimension1').val('{$APACZKA8_DIMENSION1}');
                            $('#dimension2').val('{$APACZKA8_DIMENSION2}');
                            $('#dimension3').val('{$APACZKA8_DIMENSION3}');
                            $('#weight').val('{$APACZKA8_WEIGHT}');
                        }

                        function loadPackageTemplate() {

                            $('#delete_alert_package_templates').hide();

                            if ($('#package_templates').val() == "0") {
                                $('#delete_button_package_templates').prop('disabled', true);
                                loadDefaultPackageTemplate();
                            } else {

                                $('#delete_button_package_templates').prop('disabled', false);

                                $.ajax({
                                    type: "POST",
                                    dataType: "JSON",
                                    url: '{$ajax}',
                                    data: {
                                        package_templates: 'load',
                                        templateName: $('#package_templates').val(),
                                        APACZKA8_PS_SECRET_KEY: '{$APACZKA8_PS_SECRET_KEY}'
                                    },
                                    success: function(data) {

                                        var template = JSON.parse(data.template);

                                        $('#type_of_delivery').val(template.type_of_delivery);
                                        $('#custom_shipping').val(template.custom_shipping);
                                        $('#dimension1').val(template.dimension1);
                                        $('#dimension2').val(template.dimension2);
                                        $('#dimension3').val(template.dimension3);
                                        $('#weight').val(template.weight);
                                    },
                                    error: function(xhr, status, error) {
                                        console.error(xhr);
                                    }
                                });
                            }
                        }

                        function loadPackageTemplates(showDeleteAlert = true) {

                            if (showDeleteAlert) {
                                $('#delete_alert_package_templates').hide();
                            }
                            $('#package_templates').empty();
                            $('#package_templates').append('<option value="0">Domyślny</option>');

                            $.ajax({
                                type: "POST",
                                dataType: "JSON",
                                url: '{$ajax}',
                                data: {
                                    package_templates: 'loadAll',
                                    APACZKA8_PS_SECRET_KEY: '{$APACZKA8_PS_SECRET_KEY}'
                                },
                                success: function(data) {

                                    data.forEach(function(row) {
                                        $('#package_templates').append('<option value="' + row
                                            .name + '">' + row.name + '</option>');
                                    });

                                },
                                error: function(xhr, status, error) {
                                    console.error(xhr);
                                }
                            });
                        }

                        function addPackageTemplate() {

                            $('#delete_alert_package_templates').hide();
                            $('#alert-danger-package').hide();
                            $('#alert-success-package').hide();

                            if ($('#package_template_name').val() == "") {
                                $('#alert-danger-package').show();
                            } else {

                                $.ajax({
                                    type: "POST",
                                    dataType: "JSON",
                                    url: '{$ajax}',
                                    data: {
                                        package_templates: 'add',
                                        templateName: $('#package_template_name').val(),
                                        template: {
                                            type_of_delivery: $('#type_of_delivery').val(),
                                            custom_shipping: $('#custom_shipping').val(),
                                            dimension1: $('#dimension1').val(),
                                            dimension2: $('#dimension2').val(),
                                            dimension3: $('#dimension3').val(),
                                            weight: $('#weight').val(),
                                        },
                                        APACZKA8_PS_SECRET_KEY: '{$APACZKA8_PS_SECRET_KEY}'
                                    },
                                    success: function(data) {

                                        loadPackageTemplates();
                                        $('#alert-success-package').show();
                                        $('#package_template_name').val('');
                                    },
                                    error: function(xhr, status, error) {
                                        console.error(xhr);
                                    }
                                });
                            }
                        }

                        function deletePackageTemplate() {

                            if ($('#package_templates').val() != "0") {

                                $('#delete_button_package_templates').prop('disabled', true);

                                $.ajax({
                                    type: "POST",
                                    dataType: "JSON",
                                    url: '{$ajax}',
                                    data: {
                                        package_templates: 'delete',
                                        templateName: $('#package_templates').val(),
                                        APACZKA8_PS_SECRET_KEY: '{$APACZKA8_PS_SECRET_KEY}'
                                    },
                                    success: function(data) {

                                        if (data.status) {
                                            $('#delete_alert_package_templates').show();
                                            loadPackageTemplates(false);
                                            loadDefaultPackageTemplate();
                                        }
                                    },
                                    error: function(xhr, status, error) {
                                        console.error(xhr);
                                    }
                                });
                            }
                        }
                    </script>

                    <div class="form-group" style="margin-bottom: 0px;">
                        <label for="package_templates">Szablon przesyłki</label>
                    </div>

                    <div class="input-group mb-3">
                        <select onchange="loadPackageTemplate();" class="form-control" id="package_templates">
                        </select>
                        <div class="input-group-append">
                            <button class="btn btn-danger" type="button" onclick="deletePackageTemplate();"
                                id="delete_button_package_templates" disabled>Usuń szablon</button>
                        </div>
                    </div>

                    <p class="text-success" id="delete_alert_package_templates" style="display: none;">Szablon usunięty!
                    </p>

                    <div class="form-group">
                        <label for="type_of_delivery">Rodzaj przesyłki</label>
                        <input type="hidden" id="shipment_type_code" value="PACZKA">
                        <select class="form-control" id="type_of_delivery" onchange="changeTypeOfDelivery()">
                            <option value="standard">Przesyłka w kartonie lub Foliopak</option>
                            <option value="letter">Koperta</option>
                            <option value="palette_120_80">Paleta Euro 120x80 cm</option>
                            <option value="palette_80_60">Półpaleta 80x60 cm</option>
                            <option value="palette_120_100">Paleta przemysłowa 120x100 cm</option>
                            <option value="palette_120_120">Paleta przemysłowa 120x120 cm</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="custom_shipping">Przesyłka niestandardowa</label>
                        <select class="form-control" id="custom_shipping">
                            <option value="0">Nie</option>
                            <option value="1">Tak</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="dimension1">Długość *</label>
                        <input type="text" class="form-control" id="dimension1" name="dimension1"
                            value="{$APACZKA8_DIMENSION1}">
                    </div>
                    <div class="form-group">
                        <label for="dimension2">Szerokość *</label>
                        <input type="text" class="form-control" id="dimension2" name="dimension2"
                            value="{$APACZKA8_DIMENSION2}">
                    </div>
                    <div class="form-group">
                        <label for="dimension3">Wysokość *</label>
                        <input type="text" class="form-control" id="dimension3" name="dimension3"
                            value="{$APACZKA8_DIMENSION3}">
                    </div>
                    <div class="form-group">
                        <label for="weight">Waga *</label>
                        <input type="text" class="form-control" id="weight" name="weight" value="{$APACZKA8_WEIGHT}">
                    </div>

                    <div class="input-group mb-3">
                        <input type="text" class="form-control" id="package_template_name"
                            placeholder="Nazwa szablonu przesyłki" aria-label="Nazwa szablonu przesyłki"
                            aria-describedby="basic-addon2">
                        <div class="input-group-append">
                            <button class="btn btn-primary" type="button" onclick="addPackageTemplate();">Zapisz
                                szablon</button>
                        </div>
                    </div>

                    <p class="text-danger" id="alert-danger-package" style="display: none;">Pole nazwa szablonu jest
                        puste!</p>
                    <p class="text-success" id="alert-success-package" style="display: none;">Szablon dodany poprawnie!
                    </p>

                    <div class="form-group">
                        <label for="content">Zawartość przesyłki *</label>
                        <input type="text" class="form-control" id="content" name="content"
                            value="Zamówienie {$params['id_order']}">
                    </div>

                    <div class="form-group">
                        <label for="cod">Pobranie</label>
                        <input type="text" class="form-control" id="cod" name="cod"
                            value="{if $order->module == 'ps_cashondelivery'}{round($order->total_paid_tax_incl, 2)}{/if}">
                    </div>

                    <div class="form-group">
                        <label for="value">Deklarowana wartość</label>
                        <input type="text" class="form-control" id="value" name="value"
                            value="{if $APACZKA8_AUTO_COMPLETE_DECLARATION_VALUE == '1'}{round($order->total_paid_tax_incl, 2)}{/if}">
                    </div>

                    <div class="form-group">
                        <label for="type">Sposób nadania *</label>

                        <select onchange="isCourierType(true)" type="text" class="form-control" id="type" name="type">
                            {if $APACZKA8_TYPE == 'SELF'}
                                <option value="SELF">Bez zamawiania podjazdu</option>
                                <option value="COURIER">Podjazd kuriera</option>
                            {/if}
                            {if $APACZKA8_TYPE == 'COURIER'}
                                <option value="COURIER">Podjazd kuriera</option>
                                <option value="SELF">Bez zamawiania podjazdu</option>
                            {/if}
                            {if $APACZKA8_TYPE == ''}
                                <option value="SELF">Bez zamawiania podjazdu</option>
                                <option value="COURIER">Podjazd kuriera</option>
                            {/if}

                            <select>
                    </div>

                    <div class="form-group">
                        <label id="date_text" for="date">Data odbioru</label>
                        <input type="date" class="form-control" id="date" name="date"
                            value="{$smarty.now|date_format:"%Y-%m-%d"}">
                    </div>

                    <div class="form-group">
                        <label id="hours_from_text" for="hours_from">Godziny odbioru od</label>
                        <select type="text" class="form-control" id="hours_from" name="hours_from">

                            {foreach from=$hours item=hour}
                                {if $hour == $APACZKA8_HOURS_FROM}
                                    <option value="{$hour|cat:':00'}">{$hour|cat:':00'}</option>
                                {/if}
                            {/foreach}
                            <option value="">Wybierz...</option>
                            {foreach from=$hours item=hour}
                                {if $hour != $APACZKA8_HOURS_FROM}
                                    <option value="{$hour|cat:':00'}">{$hour|cat:':00'}</option>
                                {/if}
                            {/foreach}
                            <select>
                    </div>

                    <div class="form-group">
                        <label id="hours_to_text" for="hours_to">Godziny odbioru do</label>
                        <select type="text" class="form-control" id="hours_to" name="hours_to">
                            {foreach from=$hours item=hour}
                                {if $hour == $APACZKA8_HOURS_TO}
                                    <option value="{$hour|cat:':00'}">{$hour|cat:':00'}</option>
                                {/if}
                            {/foreach}
                            <option value="">Wybierz...</option>
                            {foreach from=$hours item=hour}
                                {if $hour != $APACZKA8_HOURS_TO}
                                    <option value="{$hour|cat:':00'}">{$hour|cat:':00'}</option>
                                {/if}
                            {/foreach}
                            <select>
                    </div>


                </form>
            </div>
            <div class="col-md-6">
                <h2>Odbiorca</h2>
                <form>
                    <div class="form-group">
                        <label for="receiver_name">Nazwa firmy / Imię i nazwisko *</label>
                        <input type="text" class="form-control" id="receiver_name" name="receiver_name"
                            value="{if $address->company != ""}{$address->company}{else}{$address->firstname} {$address->lastname}{/if}">
                    </div>

                    <div class="form-group">
                        <label for="receiver_is_residential">Typ adresu</label>
                        <select class="form-control" id="receiver_is_residential">
                            {if $address->company != "" || $address->vat_number != "" }
                                <option value="0">Firmowy</option>
                                <option value="1">Prywatny</option>
                            {else}
                                <option value="1">Prywatny</option>
                                <option value="0">Firmowy</option>
                            {/if}
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="receiver_street">Ulica *</label>
                        <input type="text" class="form-control" id="receiver_street" name="receiver_street"
                            value="{$address->address1}">
                    </div>

                    <div class="form-group">
                        <label for="receiver_apartment_no">Nr lokalu</label>
                        <input type="text" class="form-control" id="receiver_apartment_no" name="receiver_apartment_no"
                            value="{$address->address2}">
                    </div>

                    <div class="form-group">
                        <label for="receiver_apartment_number">Numer mieszkania</label>
                        <input type="text" class="form-control" id="receiver_apartment_number"
                            name="receiver_apartment_number" value="">
                    </div>

                    <div class="form-group">
                        <label for="receiver_postal_code">Kod pocztowy *</label>
                        <input type="text" class="form-control" id="receiver_postal_code" name="receiver_postal_code"
                            value="{$address->postcode}">
                    </div>

                    <div class="form-group">
                        <label for="receiver_city">Miasto *</label>
                        <input type="text" class="form-control" id="receiver_city" name="receiver_city"
                            value="{$address->city}">
                    </div>

                    <div class="form-group">
                        <label for="receiver_country">Kraj *</label>
                        <input type="text" class="form-control" id="receiver_country" name="receiver_country"
                            value="{$iso_code}" style="display: none;">
                         <input type="text" class="form-control" value="{$address->country}" disabled>
                    </div>

                    <div class="form-group">
                        <label for="receiver_contact_person">Osoba kontaktowa *</label>
                        <input type="text" class="form-control" id="receiver_contact_person"
                            name="receiver_contact_person" value="{$address->firstname} {$address->lastname}">
                    </div>

                    <div class="form-group">
                        <label for="receiver_email">E-mail *</label>
                        <input type="text" class="form-control" id="receiver_email" name="receiver_email"
                            value="{$customer->email}">
                    </div>

                    <div class="form-group">
                        <label for="receiver_phone">Telefon *</label>
                        <input type="text" class="form-control" id="receiver_phone" name="receiver_phone"
                            value="{$address->phone}">
                    </div>
                </form>
            </div>
            <div class="col-md-12">

                <button type="button" class="btn btn-primary" onclick="getApaczkaServices()">Wyceń przesyłkę <div
                        class="apaczka-spinner spinner-border text-light"
                        style="width: 1rem; height: 1rem; display: none;"></div>
                </button>
            </div>
        </div>

        <div class="mt-3 row" id="apaczka-services" style="margin-left: 0px;">

        </div>

        <div class="row">

            <div class="col-md-12">

                <div class="form-group" style="display: none;">
                    <label for="APACZKA8_DEFAULT_POINT_DHL">APACZKA8_DEFAULT_POINT_DHL</label>
                    <input type="text" class="form-control" id="APACZKA8_DEFAULT_POINT_DHL"
                        name="APACZKA8_DEFAULT_POINT_DHL" value="{$APACZKA8_DEFAULT_POINT_DHL}">
                </div>
                <div class="form-group" style="display: none;">
                    <label for="APACZKA8_DEFAULT_POINT_DPD">APACZKA8_DEFAULT_POINT_DPD</label>
                    <input type="text" class="form-control" id="APACZKA8_DEFAULT_POINT_DPD"
                        name="APACZKA8_DEFAULT_POINT_DPD" value="{$APACZKA8_DEFAULT_POINT_DPD}">
                </div>
                <div class="form-group" style="display: none;">
                    <label for="APACZKA8_DEFAULT_POINT_INPOST">APACZKA8_DEFAULT_POINT_INPOST</label>
                    <input type="text" class="form-control" id="APACZKA8_DEFAULT_POINT_INPOST"
                        name="APACZKA8_DEFAULT_POINT_INPOST" value="{$APACZKA8_DEFAULT_POINT_INPOST}">
                </div>
                <div class="form-group" style="display: none;">
                    <label for="APACZKA8_DEFAULT_POINT_UPS">APACZKA8_DEFAULT_POINT_UPS</label>
                    <input type="text" class="form-control" id="APACZKA8_DEFAULT_POINT_UPS"
                        name="APACZKA8_DEFAULT_POINT_UPS" value="{$APACZKA8_DEFAULT_POINT_UPS}">
                </div>
                <div class="form-group" style="display: none;">
                    <label for="APACZKA8_DEFAULT_POINT_POCZTA">APACZKA8_DEFAULT_POINT_POCZTA</label>
                    <input type="text" class="form-control" id="APACZKA8_DEFAULT_POINT_POCZTA"
                        name="APACZKA8_DEFAULT_POINT_POCZTA" value="{$APACZKA8_DEFAULT_POINT_POCZTA}">
                </div>

                <div class="form-group" id="div_sender_point" style="display: none;">
                    <label for="sender_foreign_address_id">Punkt nadawczy <span
                            id="txt_sender_supplier_name"></span></label>
                    <input type="text" class="form-control" id="sender_foreign_address_id"
                        name="sender_foreign_address_id" onclick="choseDefaultPoint(true, false);">
                </div>

                <div class="form-group" style="display: none;">
                    <label for="receiver_apaczka_supplier">Typ przewoznika odbiorczego</label>
                    <input type="text" class="form-control" id="receiver_apaczka_supplier"
                        name="receiver_apaczka_supplier" value="{$apaczka_map['apaczka_supplier']}">
                </div>

                <div class="form-group" id="div_receiver_foreign_address_id">
                    <label for="receiver_foreign_address_id">Punkt odbiorczy <span
                            style="display: none;">({$apaczka_map['apaczka_supplier']})</span></label>
                    <input type="text" class="form-control" id="receiver_foreign_address_id"
                        name="receiver_foreign_address_id" value="{$apaczka_map['apaczka_point']}"
                        onclick="choseDefaultPoint(false, true);">
                </div>

                <div id="apaczka-alert-danger" class="alert alert-danger" style="display: none;">
                    <strong>Uwaga!</strong> <span id="apaczka-mesage-alert"></span>
                </div>

                <div id="apaczka-alert-success" class="alert alert-success" style="display: none;">
                    <strong>Sukces!</strong> <span id="apaczka-mesage2-alert"></span>
                </div>
            </div>

            <div class="col-md-12">

                <input type="hidden" id="selected_service_id">
                <input type="hidden" id="selected_supplier">
                <input type="hidden" id="send_reciver_point" value="0">

                <button style="display: none;" id="button-apaczka-add-order" type="button" class="btn btn-primary"
                    onclick="addApaczkaOrder()">Nadaj przesyłkę</button>
            </div>

        </div>

    </div>

</div>
<div style="display: none;">
{dump($apaczka_map)}
{dump($apaczka_order)}
{dump($address)}
{dump($customer)}
{dump($order)}
{dump($params)}
</div>