$(document).ready(function () {
    checkApiKeys();
    $('.form-group:nth-child(2)').after('<div class="form-group"><label class="control-label col-lg-4" style="font-size: 18px;"><b>Domyślne dane nadawcy</b></label></div>');

    $('.form-group:nth-child(13)').after('<div class="form-group"><label class="control-label col-lg-4" style="font-size: 18px;"><b>Domyślne ustawienia przesyłki</b></label></div>');
});

$('#APP_ID').change(function () {
    checkApiKeys();
});
$('#APP_SECRET').change(function () {
    checkApiKeys();
});

function checkApiKeys() {

    $('#alert-check-keys').remove();

    var APP_ID = $('#APP_ID').val();
    var APP_SECRET = $('#APP_SECRET').val();

    if (APP_ID != "" && APP_SECRET != "") {

        $.ajax({
            type: "POST",
            dataType: "JSON",
            url: '/module/apaczka8/validation',
            data: {
                getOrders: true,
                APP_ID: APP_ID,
                APP_SECRET: APP_SECRET
            },
            success: function (data) {

                if (data.status != "200") {

                    $('#fieldset_0 .form-wrapper').prepend('<div id="alert-check-keys" class="module_confirmation conf confirm alert alert-danger"><button type="button" class="close" data-dismiss="alert">×</button>Klucze API są niepoprawne.</div>');
                }
            },
            error: function (xhr, status, error) {
                console.error(xhr);
            }
        });
    }
}

$('#DEFAULT_POINT_DHL').click(function () {
    choseDefaultPoint('dhl');
});

$('#DEFAULT_POINT_DPD').click(function () {
    choseDefaultPoint('dpd');
});
$('#DEFAULT_POINT_INPOST').click(function () {
    choseDefaultPoint('inpost');
});
$('#DEFAULT_POINT_UPS').click(function () {
    choseDefaultPoint('ups');
});
$('#DEFAULT_POINT_POCZTA').click(function () {
    choseDefaultPoint('poczta');
});

function choseDefaultPoint(suplier = "") {

    var suplierName = "";
    var default_input_point_id = "";

    if (suplier == 'dhl') {
        suplierName = 'DHL_PARCEL';
        default_input_point_id = 'DHL';
    }
    if (suplier == 'dpd') {
        suplierName = 'DPD';
        default_input_point_id = 'DPD';
    }
    if (suplier == 'inpost') {
        suplierName = 'INPOST';
        default_input_point_id = 'INPOST';
    }
    if (suplier == 'ups') {
        suplierName = 'UPS';
        default_input_point_id = 'UPS';
    }
    if (suplier == 'poczta') {
        suplierName = 'POCZTA';
        default_input_point_id = 'POCZTA';
    }

    var APP_ID = $('#APP_ID').val();


    var apaczkaMap = new ApaczkaMap({
        app_id: APP_ID,
        onChange: function (record) {
            if (record) {
                // alert('Wybrano: ' + record.foreign_access_point_id);
                $('#DEFAULT_POINT_' + default_input_point_id).val(record.foreign_access_point_id);
            }
        }
    });

    apaczkaMap.setFilterSupplierAllowed(
        [suplierName],
        [suplierName]
    );

    apaczkaMap.show({});

}

