<?php
/**
 * <ModuleClassName> => Cheque
 * <FileName> => validation.php
 * Format expected: <ModuleClassName><FileName>ModuleFrontController
 */
class Apaczka8ValidationModuleFrontController extends ModuleFrontController
{

	const API_URL = 'https://www.apaczka.pl/api/v2/';

	const SIGN_ALGORITHM = 'sha256';

	const EXPIRES = '+30min';

	static $APP_ID;
	static $APP_SECRET;

    public function initContent()
    {
        parent::initContent();
    }

	//"pickup_courier":"0",
	// zamówienie kurier: 0 - niedostępne, 1 - dostępne, 2 - wymagane
	//point_to_point
	//point_to_door
	//door_to_door
	//door_to_point

	function isSelf( $service = null ) {
		
		if ( $service->pickup_courier != 2 ) {

			if ( $service->point_to_point == 1) {

				return true;
			}
			if ( $service->point_to_door == 1 ) {

				return true;
			}
			if ( $service->door_to_door == 1 ) {

				return true;
			}
			if ( $service->door_to_point == 1 ) {

				return true;
			}
		}

		return false;
	}

	function isCourier( $service = null ) {

		if ( $service->pickup_courier == 1 || $service->pickup_courier == 2 ) {
		
			if ( $service->door_to_door == 1 ) {

				return true;
			}
			if ( $service->door_to_point == 1 ) {

				return true;
			}
		}

		return false;
	}

    public function postProcess()
    {

		if ( $_POST['APACZKA8_PS_SECRET_KEY'] == Configuration::get('APACZKA8_PS_SECRET_KEY') ) {

			self::$APP_ID = Configuration::get('APACZKA8_ID');
			self::$APP_SECRET = Configuration::get('APACZKA8_SECRET');

			if ( isset($_POST['sender_templates']) ) {

				if ( $_POST['sender_templates'] == 'load' ) {

					die(
					json_encode( Db::getInstance()->getRow(
						'SELECT * FROM ' . _DB_PREFIX_ . 'apaczka8_templates WHERE name = "'.$_POST['templateName'].'" AND type = "sender"'
					) )
					);
				}

				if ( $_POST['sender_templates'] == 'loadAll' ) {

					die(
					json_encode( Db::getInstance()->executeS(
						'SELECT name FROM ' . _DB_PREFIX_ . 'apaczka8_templates WHERE type = "sender"'
					) )
					);
				}

				if (  $_POST['sender_templates'] == 'add'  ) {

					$status = Db::getInstance()->insert("apaczka8_templates",
						[
							"name" => $_POST['templateName'],
							"type" => "sender",
							"template" => json_encode($_POST['template'], JSON_UNESCAPED_UNICODE)
						]
					);

					die( json_encode(['status' => $status]) );
				}

				if (  $_POST['sender_templates'] == 'delete'  ) {

					$status = Db::getInstance()->delete("apaczka8_templates", "name = '" . $_POST['templateName'] ."'", 1);

					die(json_encode(['status' => $status]));
				}
			}

			if ( isset($_POST['package_templates']) ) {

				if ( $_POST['package_templates'] == 'load' ) {

					die(
						json_encode( Db::getInstance()->getRow(
							'SELECT * FROM ' . _DB_PREFIX_ . 'apaczka8_templates WHERE name = "'.$_POST['templateName'].'" AND type = "package"'
						) )
					);
				}

				if ( $_POST['package_templates'] == 'loadAll' ) {

					die(
						json_encode( Db::getInstance()->executeS(
							'SELECT name FROM ' . _DB_PREFIX_ . 'apaczka8_templates WHERE type = "package"'
						) )
					);
				}

				if (  $_POST['package_templates'] == 'add'  ) {

					$status = Db::getInstance()->insert("apaczka8_templates",
						[
							"name" => $_POST['templateName'],
							"type" => "package",
							"template" => json_encode($_POST['template'], JSON_UNESCAPED_UNICODE)
						]
					);

					die( json_encode(['status' => $status]) );
				}

				if (  $_POST['package_templates'] == 'delete'  ) {

					$status = Db::getInstance()->delete("apaczka8_templates", "name = '" . $_POST['templateName'] ."'", 1);

					die(json_encode(['status' => $status]));
				}
			}

			if ( isset( $_POST['apaczkaDelete'] ) ) {

				if ( $_POST['apaczkaDelete'] == true ) {
					
					$this->deleteApaczkaOrder( $_POST['apaczka_order_id'] );
				}
			}

			if ( isset( $_POST['getOrders'] ) ) {
				if ( $_POST['getOrders'] == true ) {

					self::$APP_ID = $_POST['APP_ID'];
					self::$APP_SECRET = $_POST['APP_SECRET'];

					echo $this->orders();
					die();
				}
			} 

			if ( isset( $_POST['apaczkaGet'] ) ) {
				if ( $_POST['apaczkaGet'] == true ) {

					echo $this->order( $_POST['apaczka_id'] );
					die();
				}
			}

			if ( isset( $_POST['getApaczkaPdf'] ) ) {
				if ( $_POST['getApaczkaPdf'] == true ) {

					echo $this->waybill( $_POST['apaczka_order_id'] );
					die();
				}
			}

			$receiverLine1 = "";
			if (empty($_POST['receiver_apartment_no'])) {

				$receiverLine1 = $_POST['receiver_street'];
			} else {
				$receiverLine1 = $_POST['receiver_street'] . " / " . $_POST['receiver_apartment_no'];
			}

			$order = [
				'address' => [
					'sender' => [
						'country_code'   => 'PL',
						'name'           => $_POST['sender_name'],
						'line1'          => $_POST['sender_street'] . " " . $_POST['sender_apartment_no'],
						'line2'          => $_POST['receiver_apartment_number'],
						'postal_code'    => $_POST['sender_postal_code'],
						'city'           => $_POST['sender_city'],
						'is_residential' => $_POST['sender_is_residential'],
						'contact_person' => $_POST['sender_contact_person'],
						'email'          => $_POST['sender_email'],
						'phone'          => $_POST['sender_phone'],
						'foreign_address_id' => $_POST['sender_foreign_address_id'] ?? '',
					],
					'receiver' => [
						'country_code'   => $_POST['receiver_country'],
						'name'           => $_POST['receiver_name'],
						'line1'          => $receiverLine1,
						'line2'          => '',
						'postal_code'    => $_POST['receiver_postal_code'],
						'city'           => $_POST['receiver_city'],
						'is_residential' => $_POST['receiver_is_residential'],
						'contact_person' => $_POST['receiver_contact_person'],
						'email'          => $_POST['receiver_email'],
						'phone'          => $_POST['receiver_phone'],
						'foreign_address_id' => $_POST['receiver_foreign_address_id'] ?? '',
					]
				],
				'option' => [
					//'31' => 1//, // powiadomienie sms,
					//'11' => '', // rod
					//'19' => '', // dostawa w sobotę,
					//'25' => '', // dostawa w godzinach,
					//'58' => '', //ostronie
				],
				'shipment_value' => $_POST['value'],
				//date_format( date_create( $date ), "Y-m-d H:i" )
				'pickup' => [
					'type' => $_POST['type'] ?? '',//, COURIER, SELF, BOX_MACHINE, POCZTA
					'date' => date_format( date_create( $_POST['date'] ), "Y-m-d" ), // Y-m-d,
					'hours_from' => date("H:i", strtotime($_POST['hours_from'])),
					'hours_to' => date("H:i", strtotime($_POST['hours_to']))
				],
				'notification'   => [
					'new'      => [ // Powiadomienia o utworzeniu przesyłki
						'isReceiverEmail' => null, // 0 / 1
						'isReceiverSms'   => null, // 0 / 1
						'isSenderEmail'   => null  // 0 / 1
					],
					'sent'     => [ // Powiadomienia o wysłaniu przesyłki
						'isReceiverEmail' => null, // 0 / 1
						'isReceiverSms'   => null, // 0 / 1
						'isSenderEmail'   => null, // 0 / 1
						'isSenderSms'     => null, // 0 / 1
					],
					'exception' => [ // Powiadomienia o wyjątku
						'isReceiverEmail' => null, // 0 / 1
						'isReceiverSms'   => null, // 0 / 1
						'isSenderEmail'   => null, // 0 / 1
						'isSenderSms'     => null, // 0 / 1
					],
					'delivered' => [ // Powiadomienia o doręczeniu
						'isReceiverEmail' => null, // 0 / 1
						'isReceiverSms'   => null, // 0 / 1
						'isSenderEmail'   => null, // 0 / 1
						'isSenderSms'     => null, // 0 / 1
					]
				],
				'shipment' => [
					[
						'dimension1' => $_POST['dimension1'],
						'dimension2' => $_POST['dimension2'],
						'dimension3' => $_POST['dimension3'],
						'weight'     => $_POST['weight'],
						'is_nstd'    => $_POST['custom_shipping'],
						'shipment_type_code' => $_POST['shipment_type_code'],
					]
				],
				// 'comment' => 'komentarz',
				'content'        => $_POST['content']
				// 'full' => 1//pokaze ceny dodatków
			];

			if ( $_POST['cod'] != "" ) {
				
				$order['cod'] = array(
					'amount' => $_POST['cod'],
					'bankaccount' => $_POST['sender_bank_account_number']
				);
			}

			if ( isset($_POST['service_id']) ) {

				$order['service_id'] = $_POST['service_id'];

				$apaczka_order = json_decode( $this->order_send($order) );

				if ( $apaczka_order->status == '200' ) {

					// $query = 'DROP TABLE ' . _DB_PREFIX_ . 'apaczka8;';
					$query = 'INSERT INTO ' . _DB_PREFIX_ . 'apaczka8 (ps_id, apaczka_id )
					VALUES ( "' . $_POST['ps_id'] . '", "' . $apaczka_order->response->order->id . '" );';

					Db::getInstance()->execute($query);
				}

				echo json_encode( $apaczka_order );
				// echo $this->order_send($order);
			} else {

				// $points = $this->points('UPS');

				// echo $this->order_valuation($order);
				$services = array();

				$order_valuation = json_decode( $this->order_valuation($order) );
				$service_structure = json_decode( $this->service_structure() );

				// echo "<pre>";
				// print_r($service_structure);
				// echo "</pre>";

				if ( isset( $service_structure->response->services ) ) {
					
					foreach ( $service_structure->response->services as $service ) {

						foreach ( $order_valuation->response->price_table as $key => $value ) {

							if ( $key == $service->service_id ) {

								if ( $_POST['type'] == "SELF" && $this->isSelf( $service ) ) {

									array_push( $services, array(
										"service_id" => $service->service_id,
										"supplier" => strtolower( $service->supplier ),
										"name" => $service->name,
										"door_to_door" => $service->door_to_door,
										"door_to_point" => $service->door_to_point,
										"point_to_point" => $service->point_to_point,
										"point_to_door" => $service->point_to_door,
										"pickup_courier" => $service->pickup_courier,
										"price" => number_format($value->price, 2, '.', ''),
										"price_gross" => round( ( $value->price_gross / 100 ), 2 ),
									) );

								}

								if ( $_POST['type'] == "COURIER" && $this->isCourier( $service ) ) {

									array_push( $services, array(
										"service_id" => $service->service_id,
										"supplier" => strtolower( $service->supplier ),
										"name" => $service->name,
										"door_to_door" => $service->door_to_door,
										"door_to_point" => $service->door_to_point,
										"point_to_point" => $service->point_to_point,
										"point_to_door" => $service->point_to_door,
										"pickup_courier" => $service->pickup_courier,
										"price" => $value->price,
										"price_gross" => (float)round( ( $value->price_gross / 100 ), 2 ),
									) );

								}
							}
						}
					}
				}

				$priceGross = array_column($services, 'price_gross');
				array_multisort($priceGross, SORT_ASC, $services);

				//number_format($value->price, 2, '.', '')
				for( $s = 0; $s < count($services); $s++ ) {
					$services[$s]["price_gross"] = number_format($services[$s]["price_gross"], 2, '.', '');
				}


				// echo "<pre>";
				// print_r( $service_structure->response->services );
				// print_r( $order_valuation->response->price_table );
				echo json_encode( $services );
				// print_r( $services );
				// echo "</pre>";
			}
		}
    }

	function deleteApaczkaOrder( $order_id ) 
	{
		$cancel_order = json_decode( $this->cancel_order( $order_id ) );

		if ( $cancel_order->status == "200" || $cancel_order->status == "400" ) {

			$query = 'DELETE FROM ' . _DB_PREFIX_ . 'apaczka8 WHERE apaczka_id = "' . $order_id . '";';

			Db::getInstance()->execute($query);
		}

		echo json_encode( $cancel_order );
		die();
	}
	
	public static function request( $route, $data = null) {

		$ch = curl_init();
		curl_setopt( $ch, CURLOPT_URL, self::API_URL . $route );
		curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($ch, CURLOPT_VERBOSE, true);

		curl_setopt( $ch, CURLOPT_POSTFIELDS, http_build_query( self::buildRequest($route, $data) ) );

		$result = curl_exec( $ch );

		if ( $result === false ) {
			curl_close( $ch );

			return false;
		}
		curl_close( $ch );

		return $result;
	}

	public static function buildRequest( $route, $data = [] ) {
		
		$data = json_encode($data);
		$expires = strtotime( self::EXPIRES );
		return [
			'app_id'    => self::$APP_ID,
			'request'   => $data,
			'expires'   => $expires,
			'signature' => self::getSignature( self::stringToSign( self::$APP_ID, $route, $data, $expires ), self::$APP_SECRET )
		];
	}

	public static function order( $id ) {
		return self::request( __FUNCTION__ . '/' . $id . '/' );
	}

	public static function orders ($page = 1, $limit = 10) {
		return self::request( __FUNCTION__ . '/', [
			'page' => $page,
			'limit' => $limit
		]);
	}

	public static function waybill( $id ) {
		return self::request( __FUNCTION__ . '/' . $id . '/' );
	}

	public static function pickup_hours ($postal_code, $service_id = false) {
		return self::request( __FUNCTION__ . '/', [
			'postal_code' => $postal_code,
			'service_id' => $service_id
		]);
	}

	public static function order_valuation ($order) {
		return self::request( __FUNCTION__ . '/', [
			'order' => $order
		]);
	}

	public static function order_send ($order) {
		return self::request( __FUNCTION__ . '/', [
			'order' => $order,
            'system' => 'prestashop8'
		]);
	}

	public static function cancel_order( $id ) {
		return self::request( __FUNCTION__ . '/' . $id . '/' );
	}

	public static function service_structure () {
		return self::request( __FUNCTION__ . '/');
	}

	public static function points ($type = null) {
		return self::request( __FUNCTION__ . '/' . $type . '/');
	}

	public static function customer_register ($customer) {
		return self::request( __FUNCTION__ . '/', [
			'customer' => $customer
		]);
	}

	public static function turn_in( $order_ids = [] ) {
		return self::request( __FUNCTION__ . '/', [
			'order_ids' => $order_ids
		]);
	}

	/**
	 * @param $string
	 * @param $key
	 *
	 * @return string
	 */
	public static function getSignature( $string, $key ) {
		return hash_hmac( self::SIGN_ALGORITHM, $string, $key );
	}

	/**
	 * @param $appId
	 * @param $route
	 * @param $data
	 * @param $expires
	 *
	 * @return string
	 */
	public static function stringToSign( $appId, $route, $data, $expires ) {
		return sprintf( "%s:%s:%s:%s", $appId, $route, $data, $expires );
	}
}