<?php

if (!defined('_PS_VERSION_')) {
    exit;
}

class Apaczka8 extends Module
{
    public $hours = array( 8, 9, 10, 11, 12, 13, 14, 15, 16, 17 );

    public function __construct()
    {
        //Required attributes
        $this->name = 'apaczka8';
        $this->tab = 'shipping_logistics';
        $this->version = '1.1.0';
        $this->author = 'Apaczka';
        $this->displayName = $this->l('Przesyłki Apaczka.pl');
        $this->description = $this->l('Wtyczka "Apaczka" to niezastąpione narzędzie dla właścicieli sklepów internetowych opartych na platformie PrestaShop w wersji 1.7.7.1+ oraz 8. Pozwala ona na łatwe i efektywne zarządzanie dostawą i wysyłką zamówień, co sprawia, że Twoja działalność e-commerce staje się bardziej efektywna i konkurencyjna.');
        //Optional non-localized attributes
        $this->need_instance = 0;
        $this->ps_versions_compliancy = [
            // 'min' => '1.7.6.8',
            'min' => '1.7.7.0',
            'max' => '8.2.1',
        ];
        $this->bootstrap = true;
        parent::__construct();
        //Optional localizable attributes
        $this->confirmUninstall = $this->l('Do you still you
            want to uninstall the Hello World module?');
    }

    public function install()
    {

        $query = 'CREATE TABLE IF NOT EXISTS ' . _DB_PREFIX_ . 'apaczka8 (
            ps_id varchar(255),
            apaczka_id varchar(255)
        ) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=utf8;';

        Db::getInstance()->execute($query);

        $query = 'CREATE TABLE IF NOT EXISTS ' . _DB_PREFIX_ . 'apaczka8_templates (
            name varchar(255) NULL,
            type varchar(255) NULL,
            template JSON NULL
        ) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=utf8;';

        Db::getInstance()->execute($query);

        return parent::install() &&
            $this->registerHook('displayAdminOrder') && 
            $this->registerHook('actionAdminControllerSetMedia') &&
            Configuration::updateValue('APACZKA8_PS_SECRET_KEY', $this->randomString(16));
    }

    public function hookActionAdminControllerSetMedia($params)
    {
        $controller = $this->context->controller;
        $controller->addJs($this->_path . 'views/js/apaczka.js');
    }

    public function uninstall()
    {
        $query = 'DROP TABLE ' . _DB_PREFIX_ . 'apaczka8;';

        Db::getInstance()->execute($query);

        return parent::uninstall();
    }

    // function apaczkaMapActive() {
        
    //     if (Module::isInstalled($moduleName)) {
    //         $moduleInstance = Module::getInstanceByName($moduleName);
    //         if ($moduleInstance->active) {
    //             return true;
    //         }
    //     }

    //     return false;
    // }

    function randomString($i_max) {
        $string = '0123456789abcdefghijklmnoprstuwyzABCDEFGHIJKLMNOPRSTUWYZ';
        $random = '';
    
        for ($i = 1; $i <= $i_max; $i++) {
            $random .= $string[rand(0, strlen($string) - 1)];
        }
    
        return $random;
    }

    public function hookDisplayAdminOrder($params)
    {

        // $query = 'DELETE FROM ' . _DB_PREFIX_ . 'apaczka8 WHERE apaczka_id = "' . $order_id . '";';
        $db = Db::getInstance();
        $query = 'SELECT * FROM ' . _DB_PREFIX_ . 'apaczka8 WHERE ps_id = ' . $params['id_order'] . ';';

        $apaczka_order = $db->getRow($query);
        if (Module::isInstalled('apaczka')) {
            $apaczka_map = $db->getRow( 'SELECT apaczka_supplier, apaczka_point FROM ' . _DB_PREFIX_ . 'orders WHERE id_order = ' . $params['id_order'] . ';' );
        } else {
            $apaczka_map = ['apaczka_supplier' => "", "apaczka_point" => ""];
        }

        $order = new Order($params['id_order']);
        $address = new Address($order->id_address_delivery);
        $customer = new Customer($order->id_customer);//id_customer
        // Pobranie ID kraju z adresu
        $country = new Country($address->id_country);
        $iso_code = $country->iso_code; // Kod ISO kraju

        $this->context->smarty->assign([
            'apaczka_order' => $apaczka_order,
            'apaczka_map' => $apaczka_map,
            'hours' => $this->hours,
            'order' => $order,
            'address' => $address,
            'customer' => $customer,
            'params' => $params,
            'iso_code' => $iso_code,
            'ajax' => Context::getContext()->link->getModuleLink('apaczka8', 'validation', array()),
            'APACZKA8_NAME' => Configuration::get('APACZKA8_NAME'),
            'APACZKA8_PS_SECRET_KEY' => Configuration::get('APACZKA8_PS_SECRET_KEY'),
            'APACZKA8_STREET' => Configuration::get('APACZKA8_STREET'),
            'APACZKA8_APARTMENT_NO' => Configuration::get('APACZKA8_APARTMENT_NO'),
            'APACZKA8_APARTMENT_NUMBER' => Configuration::get('APACZKA8_APARTMENT_NUMBER'),
            'APACZKA8_POSTAL_CODE' => Configuration::get('APACZKA8_POSTAL_CODE'),
            'APACZKA8_CITY' => Configuration::get('APACZKA8_CITY'),
            'APACZKA8_CONTACT_PERSON' => Configuration::get('APACZKA8_CONTACT_PERSON'),
            'APACZKA8_EMAIL' => Configuration::get('APACZKA8_EMAIL'),
            'APACZKA8_PHONE' => Configuration::get('APACZKA8_PHONE'),
            'APACZKA8_BANK_ACCOUNT_NUMBER' => Configuration::get('APACZKA8_BANK_ACCOUNT_NUMBER'),
            'APACZKA8_DIMENSION1' => Configuration::get('APACZKA8_DIMENSION1'),
            'APACZKA8_DIMENSION2' => Configuration::get('APACZKA8_DIMENSION2'),
            'APACZKA8_DIMENSION3' => Configuration::get('APACZKA8_DIMENSION3'),
            'APACZKA8_WEIGHT' => Configuration::get('APACZKA8_WEIGHT'),
            // 'APACZKA8_CONTENT' => Configuration::get('APACZKA8_CONTENT'),
            'APACZKA8_AUTO_COMPLETE_DECLARATION_VALUE' => Configuration::get('APACZKA8_AUTO_COMPLETE_DECLARATION_VALUE'),
            'APACZKA8_TYPE' => Configuration::get('APACZKA8_TYPE'),
            'APACZKA8_HOURS_FROM' => Configuration::get('APACZKA8_HOURS_FROM'),
            'APACZKA8_HOURS_TO' => Configuration::get('APACZKA8_HOURS_TO'),
            'APACZKA8_DEFAULT_POINT_DHL' => Configuration::get('APACZKA8_DEFAULT_POINT_DHL'),
            'APACZKA8_DEFAULT_POINT_DPD' => Configuration::get('APACZKA8_DEFAULT_POINT_DPD'),
            'APACZKA8_DEFAULT_POINT_INPOST' => Configuration::get('APACZKA8_DEFAULT_POINT_INPOST'),
            'APACZKA8_DEFAULT_POINT_UPS' => Configuration::get('APACZKA8_DEFAULT_POINT_UPS'),
            'APACZKA8_DEFAULT_POINT_POCZTA' => Configuration::get('APACZKA8_DEFAULT_POINT_POCZTA'),
        ]);

        return $this->display(__FILE__, 'apaczka8.tpl');
    }

    /**
     * This method handles the module's configuration page
     * @return string The page's HTML content 
     */
    public function getContent()
    {
        $output = '';

        // this part is executed only when the form is submitted
        if (Tools::isSubmit('submit' . $this->name)) {
            // retrieve the value set by the user
            $apaczka8_id = (string) Tools::getValue('APACZKA8_ID');
            $apaczka8_secret = (string) Tools::getValue('APACZKA8_SECRET');
            $apaczka8_name = (string) Tools::getValue('APACZKA8_NAME');
            $apaczka8_street = (string) Tools::getValue('APACZKA8_STREET');
            $apaczka8_apartment_no = (string) Tools::getValue('APACZKA8_APARTMENT_NO');
            $apaczka8_apartment_number = (string) Tools::getValue('APACZKA8_APARTMENT_NUMBER');
            $apaczka8_postal_code = (string) Tools::getValue('APACZKA8_POSTAL_CODE');
            $apaczka8_city = (string) Tools::getValue('APACZKA8_CITY');
            $apaczka8_contact_person = (string) Tools::getValue('APACZKA8_CONTACT_PERSON');
            $apaczka8_email = (string) Tools::getValue('APACZKA8_EMAIL');
            $apaczka8_phone = (string) Tools::getValue('APACZKA8_PHONE');
            $apaczka8_bank_account_number = (string) Tools::getValue('APACZKA8_BANK_ACCOUNT_NUMBER');
            $apaczka8_dimension1 = (string) Tools::getValue('APACZKA8_DIMENSION1');
            $apaczka8_dimension2 = (string) Tools::getValue('APACZKA8_DIMENSION2');
            $apaczka8_dimension3 = (string) Tools::getValue('APACZKA8_DIMENSION3');
            $apaczka8_weight = (string) Tools::getValue('APACZKA8_WEIGHT');
            // $apaczka8_content = (string) Tools::getValue('APACZKA8_CONTENT');
            $apaczka8_auto_complete_declaration_value = (string) Tools::getValue('APACZKA8_AUTO_COMPLETE_DECLARATION_VALUE');
            $apaczka8_type = (string) Tools::getValue('APACZKA8_TYPE');
            $apaczka8_hours_from = (string) Tools::getValue('APACZKA8_HOURS_FROM');
            $apaczka8_hours_to = (string) Tools::getValue('APACZKA8_HOURS_TO');
            $apaczka8_default_point_dhl = (string) Tools::getValue('APACZKA8_DEFAULT_POINT_DHL');
            $apaczka8_default_point_dpd = (string) Tools::getValue('APACZKA8_DEFAULT_POINT_DPD');
            $apaczka8_default_point_inpost = (string) Tools::getValue('APACZKA8_DEFAULT_POINT_INPOST');
            $apaczka8_default_point_ups = (string) Tools::getValue('APACZKA8_DEFAULT_POINT_UPS');
            $apaczka8_default_point_poczta = (string) Tools::getValue('APACZKA8_DEFAULT_POINT_POCZTA');

            // check that the value is valid
            if (empty($apaczka8_id) && empty($apaczka8_secret) ) {
                // invalid value, show an error
                $output = $this->displayError($this->l('Polę APP ID i App Secret nie mogą być puste.'));

            } elseif ( $this->checkKeys( $apaczka8_id, $apaczka8_secret ) == false && version_compare(_PS_VERSION_, '1.7.7.0', '>') ) {

                $output = $this->displayError($this->l('Klucze APP ID i App Secret są nie poprawne.'));
            } else {
                // value is ok, update it and display a confirmation message
                Configuration::updateValue('APACZKA8_ID', $apaczka8_id);
                Configuration::updateValue('APACZKA8_SECRET', $apaczka8_secret);
                Configuration::updateValue('APACZKA8_NAME', $apaczka8_name);
                Configuration::updateValue('APACZKA8_STREET', $apaczka8_street);
                Configuration::updateValue('APACZKA8_APARTMENT_NO', $apaczka8_apartment_no);
                Configuration::updateValue('APACZKA8_APARTMENT_NUMBER', $apaczka8_apartment_number);
                Configuration::updateValue('APACZKA8_POSTAL_CODE', $apaczka8_postal_code);
                Configuration::updateValue('APACZKA8_CITY', $apaczka8_city);
                Configuration::updateValue('APACZKA8_CONTACT_PERSON', $apaczka8_contact_person);
                Configuration::updateValue('APACZKA8_EMAIL', $apaczka8_email);
                Configuration::updateValue('APACZKA8_PHONE', $apaczka8_phone);
                Configuration::updateValue('APACZKA8_BANK_ACCOUNT_NUMBER', $apaczka8_bank_account_number);
                Configuration::updateValue('APACZKA8_DIMENSION1', $apaczka8_dimension1);
                Configuration::updateValue('APACZKA8_DIMENSION2', $apaczka8_dimension2);
                Configuration::updateValue('APACZKA8_DIMENSION3', $apaczka8_dimension3);
                Configuration::updateValue('APACZKA8_WEIGHT', $apaczka8_weight);
                // Configuration::updateValue('APACZKA8_CONTENT', $apaczka8_content);
                Configuration::updateValue('APACZKA8_AUTO_COMPLETE_DECLARATION_VALUE', $apaczka8_auto_complete_declaration_value);
                Configuration::updateValue('APACZKA8_TYPE', $apaczka8_type);
                Configuration::updateValue('APACZKA8_HOURS_FROM', $apaczka8_hours_from);
                Configuration::updateValue('APACZKA8_HOURS_TO', $apaczka8_hours_to);
                Configuration::updateValue('APACZKA8_DEFAULT_POINT_DHL', $apaczka8_default_point_dhl);
                Configuration::updateValue('APACZKA8_DEFAULT_POINT_DPD', $apaczka8_default_point_dpd);
                Configuration::updateValue('APACZKA8_DEFAULT_POINT_INPOST', $apaczka8_default_point_inpost);
                Configuration::updateValue('APACZKA8_DEFAULT_POINT_UPS', $apaczka8_default_point_ups);
                Configuration::updateValue('APACZKA8_DEFAULT_POINT_POCZTA', $apaczka8_default_point_poczta);

                $output = $this->displayConfirmation($this->l('Ustawienia zapisane poprawnie'));
            }
        }

        // display any message, then the form
        //$this->context->controller->addJS('https://mapa.apaczka.pl/client/apaczka.map.js');
        // $this->context->controller->addJS($this->_path.'views/js/apaczka_v9.js');

        $filePath = $this->_path.'views/js/apaczka_v14.js';

        // Wczytaj zawartość pliku do zmiennej string
        $jsContent = '';
        $jsContent = '<script src="https://mapa.apaczka.pl/client/apaczka.map.js"></script>';
        $jsContent .= '<script src="'.$filePath.'"></script>';

        return $output . $this->displayForm() . $jsContent;
    }

    function checkKeys( $APP_ID = "", $APP_SECRET = "" ) {

        return true;

        $data = array(
            'getOrders' => true,
            'APP_ID' => $APP_ID,
            'APP_SECRET' => $APP_SECRET,
            'APACZKA8_PS_SECRET_KEY' => Configuration::get('APACZKA8_PS_SECRET_KEY')
        );
        
        // Ustawienia cURL
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $this->context->link->getModuleLink('apaczka8', 'validation') );
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        // curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/x-www-form-urlencoded'));

        // Wykonaj żądanie cURL i pobierz odpowiedź
        $response = curl_exec($ch);

        if (curl_errno($ch)) {
            return false;
        }

        // Sprawdź ewentualne błędy
        // if (curl_errno($ch)) {
        //     return false;
        // }

        // Zamykamy połączenie cURL
        curl_close($ch);

        // Przetwarzamy odpowiedź JSON
        $result = json_decode($response, true);

        // echo "<pre>";
        // print_r($result);
        // echo "</pre>";
        // die();

        // Sprawdzamy odpowiedź
        if ($result['status'] == '200') {
            return true;
        }

        return false;
    }

    /**
     * Builds the configuration form
     * @return string HTML code
     */
    public function displayForm()
    {
        // Init Fields form array

        $types = array(
            array(
              'id_option' => "COURIER",
              'name' => 'Podjazd kuriera'
            ),
            array(
              'id_option' => "SELF",
              'name' => 'Bez zamawiania podjazdu'
            ),
          );

        $hours = array(
            array(
                'id_option' => 8,
                'name' => '08:00' 
            ),
            array(
                'id_option' => 9,
                'name' => '09:00' 
            ),
            array(
                'id_option' => 10,
                'name' => '10:00' 
            ),
            array(
                'id_option' => 11,
                'name' => '11:00' 
            ),
            array(
                'id_option' => 12,
                'name' => '12:00' 
            ),
            array(
                'id_option' => 13,
                'name' => '13:00' 
            ),
            array(
                'id_option' => 14,
                'name' => '14:00' 
            ),
            array(
                'id_option' => 15,
                'name' => '15:00' 
            ),
            array(
                'id_option' => 16,
                'name' => '16:00' 
            ),
            array(
                'id_option' => 17,
                'name' => '17:00' 
            ),
        );

        $form = [
            'form' => [
                'legend' => [
                    'title' => $this->l('Domyślne ustawienia Apaczka'),
                ],
                'input' => [
                    [
                        'id' => 'APP_ID',
                        'type' => 'text',
                        'label' => $this->l('APP ID'),
                        'name' => 'APACZKA8_ID',
                        'size' => 50,
                        'required' => true,
                    ],
                    [
                        'id' => 'APP_SECRET',
                        'type' => 'text',
                        'label' => $this->l('App Secret'),
                        'name' => 'APACZKA8_SECRET',
                        'size' => 50,
                        'required' => true,
                    ],
                    [
                        'type' => 'text',
                        'label' => $this->l('Nazwa firmy / Imię i nazwisko'),
                        'name' => 'APACZKA8_NAME',
                        'size' => 50,
                        'required' => true,
                    ],
                    [
                        'type' => 'text',
                        'label' => $this->l('Ulica'),
                        'name' => 'APACZKA8_STREET',
                        'size' => 50,
                        'required' => true,
                    ],
                    [
                        'type' => 'text',
                        'label' => $this->l('Nr lokalu'),
                        'name' => 'APACZKA8_APARTMENT_NO',
                        'size' => 50,
                        'required' => true,
                    ],
                    [
                        'type' => 'text',
                        'label' => $this->l('Numer mieszkania'),
                        'name' => 'APACZKA8_APARTMENT_NUMBER',
                        'size' => 50,
                        'required' => false,
                    ],
                    [
                        'type' => 'text',
                        'label' => $this->l('Kod pocztowy'),
                        'name' => 'APACZKA8_POSTAL_CODE',
                        'size' => 50,
                        'required' => true,
                    ],
                    [
                        'type' => 'text',
                        'label' => $this->l('Miasto'),
                        'name' => 'APACZKA8_CITY',
                        'size' => 50,
                        'required' => true,
                    ],
                    [
                        'type' => 'text',
                        'label' => $this->l('Osoba kontaktowa'),
                        'name' => 'APACZKA8_CONTACT_PERSON',
                        'size' => 50,
                        'required' => true,
                    ],
                    [
                        'type' => 'text',
                        'label' => $this->l('E-mail'),
                        'name' => 'APACZKA8_EMAIL',
                        'size' => 100,
                        'required' => true,
                    ],
                    [
                        'type' => 'text',
                        'label' => $this->l('Telefon'),
                        'name' => 'APACZKA8_PHONE',
                        'size' => 100,
                        'required' => true,
                    ],
                    [
                        'type' => 'text',
                        'label' => $this->l('Nr konta bankowego'),
                        'name' => 'APACZKA8_BANK_ACCOUNT_NUMBER',
                        'size' => 100,
                        'required' => true,
                    ],
                    [
                        'type' => 'text',
                        'label' => $this->l('Długość'),
                        'name' => 'APACZKA8_DIMENSION1',
                        'size' => 100,
                        'required' => true,
                    ],
                    [
                        'type' => 'text',
                        'label' => $this->l('Szerokość'),
                        'name' => 'APACZKA8_DIMENSION2',
                        'size' => 100,
                        'required' => true,
                    ],
                    [
                        'type' => 'text',
                        'label' => $this->l('Wysokość'),
                        'name' => 'APACZKA8_DIMENSION3',
                        'size' => 100,
                        'required' => true,
                    ],
                    [
                        'type' => 'text',
                        'label' => $this->l('Waga'),
                        'name' => 'APACZKA8_WEIGHT',
                        'size' => 100,
                        'required' => true,
                    ],
                    // [
                    //     'type' => 'text',
                    //     'label' => $this->l('Zawartość przesyłki'),
                    //     'name' => 'APACZKA8_CONTENT',
                    //     'size' => 100,
                    //     'required' => true,
                    // ],
                    [//automatically complete the value declaration amount
                        'type' => 'radio',
                        'label' => $this->l('Automatycznie uzupełniać kwotę deklaracji wartości'),
                        'name' => 'APACZKA8_AUTO_COMPLETE_DECLARATION_VALUE',
                        'class' => 't',
                        // 'is_bool' => true,
                        'values'    => array(                                 // $values contains the data itself.
                            array(                          // The content of the 'id' attribute of the <input> tag, and of the 'for' attribute for the <label> tag.
                              'value' => 1,                                     // The content of the 'value' attribute of the <input> tag.   
                              'label' => $this->l('Tak')                    // The <label> for this radio button.
                            ),
                            array(
                              'value' => 0,
                              'label' => $this->l('Nie')
                            )
                        )
                    ],
                    [
                        'type' => 'select',
                        'label' => $this->l('Domyślny sposób nadania'),
                        'name' => 'APACZKA8_TYPE',
                        'size' => 3,
                        'required' => true,
                        'options' => array(
                            'query' => $types, // $options contains the data itself.
                            'id' => 'id_option', // The value of the 'id' key must be the same as the key for 'value' attribute of the <option> tag in each $options sub-array.
                            'name' => 'name' // The value of the 'name' key must be the same as the key for the text content of the <option> tag in each $options sub-array.
                          )
                    ],
                    [
                        'type' => 'select',
                        'label' => $this->l('Domyślny godziny odbioru od'),
                        'name' => 'APACZKA8_HOURS_FROM',
                        'size' => 3,
                        'required' => true,
                        'options' => array(
                            'query' => $hours, // $options contains the data itself.
                            'id' => 'id_option', // The value of the 'id' key must be the same as the key for 'value' attribute of the <option> tag in each $options sub-array.
                            'name' => 'name' // The value of the 'name' key must be the same as the key for the text content of the <option> tag in each $options sub-array.
                          )
                    ],
                    [
                        'type' => 'select',
                        'label' => $this->l('Domyślny godziny odbioru do'),
                        'name' => 'APACZKA8_HOURS_TO',
                        'size' => 3,
                        'required' => true,
                        'options' => array(
                            'query' => $hours, // $options contains the data itself.
                            'id' => 'id_option', // The value of the 'id' key must be the same as the key for 'value' attribute of the <option> tag in each $options sub-array.
                            'name' => 'name' // The value of the 'name' key must be the same as the key for the text content of the <option> tag in each $options sub-array.
                          )
                    ],
                    [
                        'id' => 'DEFAULT_POINT_DHL',
                        'type' => 'text',
                        'label' => $this->l('Domyślny punkt DHL'),
                        'name' => 'APACZKA8_DEFAULT_POINT_DHL',
                        'size' => 10,
                        'required' => false,
                        'onclick' => 'showTxtV1()',
                    ],
                    [
                        'id' => 'DEFAULT_POINT_DPD',
                        'type' => 'text',
                        'label' => $this->l('Domyślny punkt DPD'),
                        'name' => 'APACZKA8_DEFAULT_POINT_DPD',
                        'size' => 10,
                        'required' => false,
                    ],
                    [
                        'id' => 'DEFAULT_POINT_INPOST',
                        'type' => 'text',
                        'label' => $this->l('Domyślny punkt INPOST'),
                        'name' => 'APACZKA8_DEFAULT_POINT_INPOST',
                        'size' => 10,
                        'required' => false,
                    ],
                    [
                        'id' => 'DEFAULT_POINT_UPS',
                        'type' => 'text',
                        'label' => $this->l('Domyślny punkt UPS'),
                        'name' => 'APACZKA8_DEFAULT_POINT_UPS',
                        'size' => 10,
                        'required' => false,
                    ],
                    [
                        'id' => 'DEFAULT_POINT_POCZTA',
                        'type' => 'text',
                        'label' => $this->l('Domyślny punkt Pocztowy'),
                        'name' => 'APACZKA8_DEFAULT_POINT_POCZTA',
                        'size' => 10,
                        'required' => false,
                    ],
                ],
                'submit' => [
                    'title' => $this->l('Zapisz'),
                    'class' => 'btn btn-default pull-right',
                ],
            ]
        ];

        $helper = new HelperForm();

        // Module, token and currentIndex
        $helper->table = $this->table;
        $helper->name_controller = $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->currentIndex = AdminController::$currentIndex . '&' . http_build_query(['configure' => $this->name]);
        $helper->submit_action = 'submit' . $this->name;

        // Default language
        $helper->default_form_language = (int) Configuration::get('PS_LANG_DEFAULT');

        // Load current value into the form
        $helper->fields_value['APACZKA8_ID'] = Tools::getValue('APACZKA8_ID', Configuration::get('APACZKA8_ID'));
        $helper->fields_value['APACZKA8_SECRET'] = Tools::getValue('APACZKA8_SECRET', Configuration::get('APACZKA8_SECRET'));
        $helper->fields_value['APACZKA8_NAME'] = Tools::getValue('APACZKA8_NAME', Configuration::get('APACZKA8_NAME'));
        $helper->fields_value['APACZKA8_STREET'] = Tools::getValue('APACZKA8_STREET', Configuration::get('APACZKA8_STREET'));
        $helper->fields_value['APACZKA8_APARTMENT_NO'] = Tools::getValue('APACZKA8_APARTMENT_NO', Configuration::get('APACZKA8_APARTMENT_NO'));
        $helper->fields_value['APACZKA8_APARTMENT_NUMBER'] = Tools::getValue('APACZKA8_APARTMENT_NUMBER', Configuration::get('APACZKA8_APARTMENT_NUMBER'));
        $helper->fields_value['APACZKA8_POSTAL_CODE'] = Tools::getValue('APACZKA8_POSTAL_CODE', Configuration::get('APACZKA8_POSTAL_CODE'));
        $helper->fields_value['APACZKA8_CITY'] = Tools::getValue('APACZKA8_CITY', Configuration::get('APACZKA8_CITY'));
        $helper->fields_value['APACZKA8_CONTACT_PERSON'] = Tools::getValue('APACZKA8_CONTACT_PERSON', Configuration::get('APACZKA8_CONTACT_PERSON'));
        $helper->fields_value['APACZKA8_EMAIL'] = Tools::getValue('APACZKA8_EMAIL', Configuration::get('APACZKA8_EMAIL'));
        $helper->fields_value['APACZKA8_PHONE'] = Tools::getValue('APACZKA8_PHONE', Configuration::get('APACZKA8_PHONE'));
        $helper->fields_value['APACZKA8_BANK_ACCOUNT_NUMBER'] = Tools::getValue('APACZKA8_BANK_ACCOUNT_NUMBER', Configuration::get('APACZKA8_BANK_ACCOUNT_NUMBER'));
        $helper->fields_value['APACZKA8_DIMENSION1'] = Tools::getValue('APACZKA8_DIMENSION1', Configuration::get('APACZKA8_DIMENSION1'));
        $helper->fields_value['APACZKA8_DIMENSION2'] = Tools::getValue('APACZKA8_DIMENSION2', Configuration::get('APACZKA8_DIMENSION2'));
        $helper->fields_value['APACZKA8_DIMENSION3'] = Tools::getValue('APACZKA8_DIMENSION3', Configuration::get('APACZKA8_DIMENSION3'));
        $helper->fields_value['APACZKA8_WEIGHT'] = Tools::getValue('APACZKA8_WEIGHT', Configuration::get('APACZKA8_WEIGHT'));
        // $helper->fields_value['APACZKA8_CONTENT'] = Tools::getValue('APACZKA8_CONTENT', Configuration::get('APACZKA8_CONTENT'));
        $helper->fields_value['APACZKA8_AUTO_COMPLETE_DECLARATION_VALUE'] = Tools::getValue('APACZKA8_AUTO_COMPLETE_DECLARATION_VALUE', Configuration::get('APACZKA8_AUTO_COMPLETE_DECLARATION_VALUE'));
        $helper->fields_value['APACZKA8_TYPE'] = Tools::getValue('APACZKA8_TYPE', Configuration::get('APACZKA8_TYPE'));
        $helper->fields_value['APACZKA8_HOURS_FROM'] = Tools::getValue('APACZKA8_HOURS_FROM', Configuration::get('APACZKA8_HOURS_FROM'));
        $helper->fields_value['APACZKA8_HOURS_TO'] = Tools::getValue('APACZKA8_HOURS_TO', Configuration::get('APACZKA8_HOURS_TO'));
        $helper->fields_value['APACZKA8_DEFAULT_POINT_DHL'] = Tools::getValue('APACZKA8_DEFAULT_POINT_DHL', Configuration::get('APACZKA8_DEFAULT_POINT_DHL'));
        $helper->fields_value['APACZKA8_DEFAULT_POINT_DPD'] = Tools::getValue('APACZKA8_DEFAULT_POINT_DPD', Configuration::get('APACZKA8_DEFAULT_POINT_DPD'));
        $helper->fields_value['APACZKA8_DEFAULT_POINT_INPOST'] = Tools::getValue('APACZKA8_DEFAULT_POINT_INPOST', Configuration::get('APACZKA8_DEFAULT_POINT_INPOST'));
        $helper->fields_value['APACZKA8_DEFAULT_POINT_UPS'] = Tools::getValue('APACZKA8_DEFAULT_POINT_UPS', Configuration::get('APACZKA8_DEFAULT_POINT_UPS'));
        $helper->fields_value['APACZKA8_DEFAULT_POINT_POCZTA'] = Tools::getValue('APACZKA8_DEFAULT_POINT_POCZTA', Configuration::get('APACZKA8_DEFAULT_POINT_POCZTA'));

        return $helper->generateForm([$form]);
    }
}