(function ($) {





    var apaczkaContext = {





        clearErrors: false





    }











    apaczkaBind = function() {





        $('form.apaczka-form-ajax').apaczkaAjaxSubmit();





        $('#apaczka-refresh-services').apaczkaRefreshServices();





        $('.apaczka-check-checkboxes').apaczkaCheckChecboxes();





        $('select.apaczka-package-type').apaczkaManagePackageFields();





        $('input.apaczka-map-combo').apaczkaBindComboboxMap();





        $('.apaczka-template-btn').apaczkaManageTemplateCreation();





        $('.apaczka-btn-remove-sender').apaczkaListItemRemove();





        $('.apaczka-btn-remove-package').apaczkaListItemRemove();





        $('.apaczka-order-switch-senders').apaczkaSwitchSender();





        $('.apaczka-order-switch-packages').apaczkaSwitchPackage();





        $('.apaczka-order-service').apaczkaSwitchOrderService();





        $('select.form-control, input.form-control, input.form-check-input').apaczkaBindResetToPrices();





    };











    apaczkaRebind = function(content) {





        content.find('form').apaczkaAjaxSubmit();





        content.find('#apaczka-refresh-services').apaczkaRefreshServices();





        content.find('.apaczka-check-checkboxes').apaczkaCheckChecboxes();





        content.find('select.apaczka-package-type').apaczkaManagePackageFields();





        content.find('input.apaczka-map-combo').apaczkaBindComboboxMap();





        content.find('.apaczka-template-btn').apaczkaManageTemplateCreation();





        content.find('.apaczka-btn-remove-sender').apaczkaListItemRemove();





        content.find('.apaczka-btn-remove-package').apaczkaListItemRemove();





        content.find('.apaczka-order-service').apaczkaSwitchOrderService();





        $('select.form-control, input.form-control, input.form-check-input').apaczkaBindResetToPrices();





    };











    apaczkaClearErrors = function() {





        if (!isApaczkaClearErrorsAllowed()) {





            return;





        }











        $(".apaczka-form-ajax").find('.alert').remove();





        $(".apaczka-form-ajax").find('.invalid-feedback').remove();





        $(".apaczka-form-ajax").find(".form-control").removeClass('is-invalid');





    }











    apaczkaDisableClearErrors = function () {





        apaczkaContext.clearErrors = false;





    }











    apaczkaEnableClearErrors = function () {





        apaczkaContext.clearErrors  = true;





    }











    isApaczkaClearErrorsAllowed = function () {





        return apaczkaContext.clearErrors;





    }











    $.fn.apaczkaAjaxSubmit = function () {





        this.each(function () {





            var f = $(this);





            let flagName = 'apaczka-form-ready';











            if (typeof f.data(flagName) !== 'undefined') {





                return;





            }





            f.data(flagName, true);











            f.on('submit', function (event) {





                event.preventDefault();





                f.find('submit, button').prop('disabled', true);





                let container = f.data('container');











                $.ajax({





                    url: f.attr('action'),





                    type: f.attr('method'),





                    dataType: 'json',





                    data: f.serialize(),





                    success: function (data) {





                        if (typeof data.content !== 'undefined') {





                            if (typeof container !== 'undefined') {





                                let content = $(data.content);





                                $(container).replaceWith(content);





                                apaczkaRebind(content);





                            }











                            if (typeof data.reloadPage !== 'undefined' && true == data.reloadPage) {





                                setTimeout(() => window.location.reload(), 200);





                            }





                        }





                    },





                    error: function () {





                        alert('Error');





                        f.find('submit, button').prop('disabled', false);





                    }





                });





            });





        });











        return this;





    };











    $.fn.apaczkaRefreshServices = function () {





        this.each(function () {





            var f = $(this);











            f.click(function(event) {





                event.preventDefault();





                let container =  $(this).data('container');











                $.ajax({





                    url: $(this).attr('href'),





                    success: function (data) {





                        if (typeof data.content !== 'undefined') {





                            let content = $(data.content);





                            $(container).replaceWith(content);





                            apaczkaRebind(content);





                        }





                    },





                });











                return false;





            });





        });











        return this;





    };











    $.fn.apaczkaCheckChecboxes = function() {





        this.each(function () {





            var f = $(this);











            f.click(function(event) {





                event.preventDefault();





                let container = $(this).data('container');





                $(container).find('input[type="checkbox"]').each(function() {





                   $(this).prop( "checked", true);





                });





                return false;





            });





        });











        return this;





    };











    $.fn.apaczkaManagePackageFields = function() {











        let criterias = [





            {name: 'paleta',                lengthEnabled: false, lengthValue: 120, widthEnabled: false, widthValue: 80, heightEnabled: true, heightValue: null, weightEnabled: true, weightValue: null},





            {name: 'polpaleta',             lengthEnabled: false, lengthValue: 60, widthEnabled: false, widthValue: 80, heightEnabled: true, heightValue: null, weightEnabled: true, weightValue: null},





            {name: 'paleta_przemyslowa',    lengthEnabled: false, lengthValue: 120, widthEnabled: false, widthValue: 100, heightEnabled: true, heightValue: null, weightEnabled: true, weightValue: null},





            {name: 'paleta_przemyslowa_b',  lengthEnabled: false, lengthValue: 120, widthEnabled: false, widthValue: 120, heightEnabled: true, heightValue: null, weightEnabled: true, weightValue: null},





        ];











        this.each(function () {





            let field = $(this);











            let fieldLength = $(field.data('length'));





            let fieldWidth = $(field.data('width'));





            let fieldHeight = $(field.data('height'));





            let fieldWeight = $(field.data('weight'));











            $(field).change(function() {





                fieldLength.removeProp('readonly').removeAttr('readonly');





                fieldWidth.removeProp('readonly').removeAttr('readonly');





                fieldHeight.removeProp('readonly').removeAttr('readonly');





                fieldWeight.removeProp('readonly').removeAttr('readonly');











                let chosenType = $(field).val().toString().toLowerCase();











                for (let criteria of criterias) {





                    if (criteria.name === chosenType) {





                        if (!criteria.lengthEnabled) {





                            fieldLength.prop('readonly', true);





                            fieldLength.val(criteria.lengthValue);





                        }





                        if (!criteria.widthEnabled) {





                            fieldWidth.prop('readonly', true);





                            fieldWidth.val(criteria.widthValue);





                        }





                        if (!criteria.heightEnabled) {





                            fieldHeight.prop('readonly', true);





                            fieldHeight.val(criteria.heightValue);





                        }





                        if (!criteria.weightEnabled) {





                            fieldWeight.prop('readonly', true);





                            fieldWeight.val(criteria.weightValue);





                        }





                        return;





                    }





                };





            });











            field.trigger('change');





        });











        return this;





    };











    $.fn.apaczkaBindComboboxMap = function() {





        if (typeof apaczkaMapAppId === 'undefined') {





            return;





        }











        this.each(function () {











            let field = $(this);





            let parent = $(this).parent().parent();





            let fieldName = parent.find('input.apaczka-point-name');





            let fieldAddressFirst = parent.find('input.apaczka-point-address-first');





            let fieldAddressSecond = parent.find('input.apaczka-point-address-second');





            let supplier = field.data('supplier');











            let map = new ApaczkaMap({





                app_id : apaczkaMapAppId





            });











            if (supplier.length > 0) {





                map.setFilterSupplierAllowed([supplier]);





            }





            map.combobox({





                point_id : field.attr('id'),





                criteria: [





                    {field: 'services_sender', operator: 'eq', value: true}





                ],





                onChange: function(record) {





                    if (record) {





                        fieldName.val(record.name);





                        fieldAddressFirst.val(record.street + ' ' + record.house_number);





                        fieldAddressSecond.val(record.postal_code + ' ' + record.city);





                    }





                },





                formatDisplay : (record) => {





                    let display = record.foreign_access_point_id;











                    if (record.name && record.name.length > 0) {





                        display += ' - ' +  record.name;





                    }





                    if (record.street && record.street.length > 0) {





                        display += ' ' + record.street + ' ' + record.house_number;





                    }





                    if (record.city && record.city.length > 0) {





                        display += '  ' + record.postal_code + ' ' + record.city;





                    }





                    return display;





                }





            });





        });











        return this;





    };











    $.fn.apaczkaManageTemplateCreation = function () {





        this.each(function () {





            var btnStart = $(this);











            btnStart.click(function(event) {





                event.preventDefault();











                btnStart.addClass('apaczka-hidden');











                let templateNameField = $($(this).data('template'));





                templateNameField.removeClass('is-invalid');





                let containerTemplateName = $($(this).data('container'));





                containerTemplateName.removeClass('apaczka-hidden');











                let btnCancel = $($(this).data('cancel'));





                btnCancel.removeClass('apaczka-hidden');











                let urlSave = $(this).data('route');





                let btnSave = $($(this).data('save'));





                btnSave.removeClass('apaczka-hidden');











                let container = $($(this).data('form'));





                let containerList = $($(this).data('list'));











                btnCancel.click(function(event) {





                    event.preventDefault();





                    containerTemplateName.addClass('apaczka-hidden');





                    btnCancel.addClass('apaczka-hidden');





                    btnSave.addClass('apaczka-hidden');





                    btnStart.removeClass('apaczka-hidden');





                });











                btnSave.click(function(event) {





                    event.preventDefault();





                    templateNameField.removeClass('is-invalid');











                    if (templateNameField.val().trim().length < 1) {





                        templateNameField.addClass('is-invalid');











                        return;





                    }











                    container.find('input,select').each(function() {





                        let field = $(this);











                        if (field && typeof field.attr("name") !== "undefined") {





                            if (field.attr("name").startsWith("settings_form[sender]")) {





                                field.attr("name", field.attr("name").replace("settings_form[sender]", "sender_form"));











                                return;





                            }











                            if (field.attr("name").startsWith("settings_form[package]")) {





                                field.attr("name", field.attr("name").replace("settings_form[package]", "package_form"));











                                return;





                            }





                        }





                    });











                    let data = container.find('input,select').serialize();











                    $.ajax({





                        url: urlSave,





                        type: 'post',





                        dataType: 'json',





                        data: data,





                        success: function (data) {





                            if (typeof data.content !== 'undefined') {





                                if (typeof container !== 'undefined') {





                                    let source = data.content;











                                    source = source.replaceAll(/name="sender_form/ig, 'name="settings_form[sender]');





                                    source = source.replaceAll(/id="sender_form/ig, 'id="settings_sender_form');





                                    source = source.replaceAll(/name="package_form/ig, 'name="settings_form[package]');





                                    source = source.replaceAll(/id="package_form/ig, 'id="settings_package_form');











                                    let content = $(source);





                                    $(container).replaceWith(content);











                                    apaczkaRebind(content);





                                    btnStart.trigger("click");





                                    if (typeof  containerList !== 'undefined') {





                                        containerList.apaczkaListReload();





                                    }





                                }





                            }





                        },





                    });











                    containerTemplateName.addClass('apaczka-hidden');





                    btnCancel.addClass('apaczka-hidden');





                    btnSave.addClass('apaczka-hidden');





                    btnStart.removeClass('apaczka-hidden');





                });











                return false;





            });





        });











        return this;





    };











    $.fn.apaczkaListItemRemove = function () {





        this.each(function () {





            var item = $(this);











            item.click(function (event) {





                event.preventDefault();





                let containerItem = $($(this).data("container-item"));





                let container = $($(this).data("container"));











                $.ajax({





                    url: $(this).attr("href"),





                    type: 'delete',





                    success: function (data) {





                        containerItem.remove();











                        if (container.find("div.row").length === 0) {





                            container.addClass("apaczka-hidden");





                        }





                    },





                });











                return false;





            });











        });











        return this;





    };











    $.fn.apaczkaListReload = function () {





        let container = $(this);





        let url = container.data('url');











        $.ajax({





            url: url,





            type: "get",





            success: function (data) {





                if (typeof data.content !== 'undefined') {





                    let content = $(data.content);





                    $(container).replaceWith(content);





                    apaczkaRebind(content);





                }





            },





        });





    };











    $.fn.apaczkaSwitchSender = function() {





        this.each(function () {





            var item = $(this);











            if (typeof  apaczkaSenders === 'undefined') {





                return;





            }











            item.change(function (event) {





                let senderId = parseInt($(this).val());





                let sender = apaczkaSenders.find(element => element.id === senderId);





                if (typeof sender === 'undefined') {





                    return;





                }





                $("#order_form_sender_companyName").val(sender.companyName);





                $("#order_form_sender_firstname").val(sender.firstname);





                $("#order_form_sender_lastname").val(sender.lastname);





                $("#order_form_sender_street").val(sender.street);





                $("#order_form_sender_homeNumber").val(sender.homeNumber);





                $("#order_form_sender_flatNumber").val(sender.flatNumber);





                $("#order_form_sender_postCode").val(sender.postCode);





                $("#order_form_sender_city").val(sender.city);





                $("#order_form_sender_contactPerson").val(sender.contactPerson);





                $("#order_form_sender_phoneNumber").val(sender.phoneNumber);





                $("#order_form_sender_email").val(sender.email);





                $("#order_form_sender_accountNumber").val(sender.accountNumber);





            });





        });











        return this;





    };

















    $.fn.apaczkaSwitchPackage = function() {











        this.each(function () {





            var item = $(this);











            if (typeof apaczkaPackages === 'undefined') {





                return;





            }





            $('select.apaczka-package-type').trigger("change");











            item.change(function (event) {





                let packageId = parseInt($(this).val());











                let package = apaczkaPackages.find(element => element.id === packageId);





                if (typeof package === 'undefined') {





                    return;





                }





                $("#order_form_package_service").val(package.service);





                $("#order_form_package_type").val(package.type);





                $("#order_form_package_length").val(package.length);





                $("#order_form_package_width").val(package.width);





                $("#order_form_package_weight").val(package.weight);





                $("#order_form_package_content").val(package.content);





                if (true == package.isOutOfStandard) {





                    $("#order_form_package_outOfStandard").prop( "checked", true);





                } else {





                    $("#order_form_package_outOfStandard").removeProp("checked").removeAttr("checked");





                }





                $('select.apaczka-package-type').trigger("change");





            });





        });











        return this;





    };











    $.fn.apaczkaSwitchOrderService = function() {





        this.each(function () {





            var item = $(this);





            var map = [





                // Podjazd kuriera





                {





                    type: 'COURIER',





                    delivery: {





                        toDoor: {





                            senderPoint: false,





                            recipientPoint: false





                        },





                        toPoint: {





                            senderPoint: false,





                            recipientPoint: true





                        }





                    }





                },





                // Dostarczę przesyłkę samodzielnie do punktu nadania.





                {





                    type: 'SELF',





                    delivery: {





                        toDoor: {





                            senderPoint: true,





                            recipientPoint: false





                        },





                        toPoint: {





                            senderPoint: true,





                            recipientPoint: true





                        }





                    }





                },





                // Dostarczę paczkę do punktu poczty polskiej - Kurier 48.





                {





                    type: 'POCZTA',





                    delivery: {





                        toDoor: {





                            senderPoint: false,





                            recipientPoint: false





                        },





                        toPoint: {





                            senderPoint: false,





                            recipientPoint: true





                        }





                    }





                },





           ];











            item.click(function(event) {





                event.preventDefault();





                apaczkaClearErrors();





                $('.apaczka-order-service').removeClass('apaczka-order-service-selected');





                $(this).addClass('apaczka-order-service-selected');











                $('.apaczka-sender-point-container').addClass('apaczka-hidden');





                $('.apaczka-recipient-point-container').addClass('apaczka-hidden');





                $("#order_form_senderPoint").val("");





                // $("#order_form_recipientPoint").val("");











                let pickupType = $('#order_form_pickupType').val();





                let serviceType = $(".apaczka-order-service-selected").data('type');





                





                let supplier = $(".apaczka-order-service-selected").data('supplier');





                let service = $(".apaczka-order-service-selected").data('service');





                $("#order_form_serviceId").val(service);





                $("#paczka-btn-make-order").text(





                    $("#apaczka-btn-make-order").data("label-order")





                );





                let pickup = map.find(element => element.type === pickupType);











                if (typeof pickup === 'undefined') {





                    return;





                }











                if (serviceType == 'D2D' || serviceType == "P2D") {





                    var fields = pickup.delivery.toDoor;





                } else if (serviceType == 'D2P' || serviceType == "P2P") {





                    var fields = pickup.delivery.toPoint;





                }











                if (typeof fields === 'undefined') {





                    return;





                }





                





                if (fields.senderPoint) {





                    const dontShowWhenService = [


                        82, //DHL Parcel Kurier D2D


                        86, //DHL POP do punktu D2P


                        50, //Orlen Paczka Punkt-Punkt P2P


                        21, //DPD Kurier D2D


                        23, //DPD Pickup Punkt-Punkt P2P


                        151, //FEDEX Kurier D2D


                        42, //InPost Kurier D2D


                        1, //UPS Standard D2D


                        15, //UPS AP Drzwi-Punkt D2P


                        24, //DPD Kurier do 9:30 D2D


                        25, //DPD Kurier do 12:00 D2D


                        84, //DHL Parcel Kurier do 9:00 D2D


                        83, //DHL Parcel Kurier do 12:00 D2D


                        4, //UPS Express Plus do 9:00 D2D


                        3, //UPS Express Plus do 12:00 D2D


                        2, //UPS Express Saver D2D


                        260, //Ambro Express D2D


                        28, //Allegro Smart DPD Kurier


                    ];





                    console.log("aktualnie gdzie nie pokazujemy pole nadania: " + dontShowWhenService);


                    console.log("usługa kliknięta: " + service);





                    const dontShowWhenType = [


                        "LIST", 


                        "PALETA",


                        "POLPALETA",


                        "PALETA_PRZEMYSLOWA",


                        "PALETA_PRZEMYSLOWA_B"


                    ];





                    console.log("type: " + $('#order_form_package_type').val() );





                    if ( !dontShowWhenService.includes(service) && !dontShowWhenType.includes($('#order_form_package_type').val() ) ) {





                        $('.apaczka-sender-point-container').removeClass('apaczka-hidden');





                        let sendigPoint = sendigPoints.find(element => element.type === supplier);











                        if (typeof sendigPoint !== "undefined") {





                            $("#order_form_senderPoint").val(sendigPoint.data.identity);





                        }





                    }





                }





                if (fields.recipientPoint) {





                    $('.apaczka-recipient-point-container').removeClass('apaczka-hidden');





                    if ($("#customer-choosen-delivery-point").length && 0 === $("#order_form_recipientPoint").val().trim().length) {





                        console.log('choosen field');











                        $("#order_form_recipientPoint").val(





                            $("#customer-choosen-delivery-point").data("point")





                        );





                    }





                } else {





                    $("#order_form_recipientPoint").val("");





                }





            });





        });











        if ($('.apaczka-order-service-selected').length) {





            apaczkaDisableClearErrors();





            $('.apaczka-order-service-selected').trigger("click");





            apaczkaEnableClearErrors();





        } else {





        }











        return this;





    };











    $.fn.apaczkaBindResetToPrices = function () {





        this.each(function () {





            var f = $(this);





            let skipIds = ['order_form_recipientPoint', 'order_form_senderPoint', 'order_form_serviceId', 'order_form__token'];











            if (f.attr("type") === 'hidden' || skipIds.includes(f.attr("id"))) {





                return;





            }











            f.apaczkaResetToGetPrices();





        });











        return this;





    }











    $.fn.apaczkaResetToGetPrices = function() {





        var btnLabelGetPrices =  $("#apaczka-btn-make-order").data("label-prices");











        this.each(function () {





            var item = $(this);











            item.change(function() {





                if ( $("#apaczka-btn-make-order").html() === btnLabelGetPrices){





                    return;





                }











                $('.apaczka-order-service').remove();





                $('.apaczka-sender-point-container').addClass('apaczka-hidden');





                $('.apaczka-recipient-point-container').addClass('apaczka-hidden');





                $("#order_form_recipientPoint").val("");





                $("#order_form_senderPoint").val("");





                $("#order_form_serviceId").val("");





                $("#apaczka-btn-make-order").html(btnLabelGetPrices);





                apaczkaClearErrors();





            });





        });











        return this;





    };











}(jQuery));











