<?php







declare(strict_types=1);







namespace Apaczka\Api\Client\Test\Integration;







use Apaczka\Api\Client\ApiClient;



use Apaczka\Api\Client\Common\CollectionInterface;



use Apaczka\Api\Client\Model\Address;



use Apaczka\Api\Client\Model\Option;



use Apaczka\Api\Client\Model\Order;



use Apaczka\Api\Client\Model\OrderCollection;



use Apaczka\Api\Client\Model\OrderStatusEnum;



use Apaczka\Api\Client\Model\PackageType;



use Apaczka\Api\Client\Model\PackageTypeEnum;



use Apaczka\Api\Client\Model\PickupType;



use Apaczka\Api\Client\Model\Point;



use Apaczka\Api\Client\Model\PointsCollection;



use Apaczka\Api\Client\Model\PointTypeEnum;



use Apaczka\Api\Client\Model\Price;



use Apaczka\Api\Client\Model\PriceCollection;



use Apaczka\Api\Client\Model\Service;



use Apaczka\Api\Client\Model\ServiceStructure;



use Apaczka\Api\Client\Model\Shipment;



use Apaczka\Api\Client\Model\ShipmentCollection;



use Apaczka\Api\Client\Model\UnitType;



use Apaczka\Api\Client\Transformer\OrderTransformer;



use PHPUnit\Framework\Assert;



use PHPUnit\Framework\TestCase;







class ApiClientTest extends TestCase



{



	private ApiClient $client;







	protected function setUp(): void



	{



		parent::setUp();







		$apiClientFactory = new ApiClientFactory();



		$this->client = $apiClientFactory->create();



	}







	public function test_get_service_structure(): ServiceStructure



	{



		// When



		$actual = $this->client->getServiceStructure();







		// Then



		Assert::assertInstanceOf(ServiceStructure::class, $actual);







		return $actual;



	}







	/**



	 * @depends test_get_service_structure



	 */



	public function test_get_service_structure_returns_unit_types(ServiceStructure $actual): void



	{



		$this->process_test_for_service_structure($actual->getUnitTypes(), UnitType::class);



	}







	/**



	 * @depends test_get_service_structure



	 */



	public function test_get_service_structure_returns_pickup_types(ServiceStructure $actual): void



	{



		$this->process_test_for_service_structure($actual->getPickupTypes(), PickupType::class);



	}







	/**



	 * @depends test_get_service_structure



	 */



	public function test_get_service_structure_returns_point_types(ServiceStructure $actual): void



	{



		$this->process_test_for_service_structure($actual->getPointTypes(), PointTypeEnum::class);



	}







	/**



	 * @depends test_get_service_structure



	 */



	public function test_get_service_structure_returns_package_types(ServiceStructure $actual): void



	{



		$this->process_test_for_service_structure($actual->getPackageTypes(), PackageType::class);



	}







	/**



	 * @depends test_get_service_structure



	 */



	public function test_get_service_structure_returns_serivces(ServiceStructure $actual): void



	{



		$this->process_test_for_service_structure($actual->getServices(), Service::class);



	}







	/**



	 * @depends test_get_service_structure



	 */



	public function test_get_service_structure_returns_options(ServiceStructure $actual): void



	{



		$this->process_test_for_service_structure($actual->getOptions(), Option::class);



	}







	/**



	 * @dataProvider pointsTypesDataProvider



	 */



	public function test_get_points(PointTypeEnum $type): void



	{



		$points = $this->client->getPoints($type);







		Assert::assertInstanceOf(PointsCollection::class, $points);



		Assert::assertFalse($points->isEmpty());



		Assert::assertInstanceOf(Point::class, $points->getIterator()[0]);



	}







	/**



	 * @dataProvider ordersNumbersProvider



	 */



	public function test_get_order(string $orderNumber): void



	{



		$order = $this->client->getOrder($orderNumber);







		Assert::assertInstanceOf(Order::class, $order);



		Assert::assertEquals($orderNumber, $order->getId());



	}







	public function test_get_orders(): void



	{



		$orders = $this->client->getOrders();







		Assert::assertInstanceOf(OrderCollection::class, $orders);



		Assert::assertFalse($orders->isEmpty());



		Assert::assertInstanceOf(Order::class, $orders->getIterator()[0]);



	}







	public function test_get_valuation(): void



	{



		$order = new Order(



			null,



			null,



			null,



			null,



			new OrderStatusEnum(OrderStatusEnum::STATUS_NEW),



			new ShipmentCollection(



				new Shipment(new PackageTypeEnum(PackageTypeEnum::PACKAGE), 10, 10, 10, 10, false)



			),



			new Price(1000, 1230, null)



		);







		$actual = $this->client->getValuation($order);







		Assert::assertInstanceOf(PriceCollection::class, $actual);



		Assert::assertFalse($actual->isEmpty());



		Assert::assertInstanceOf(Price::class, $actual->getIterator()[0]);



	}







	public function test_send_order(): Order



	{



		$services = $this->client->getServiceStructure()->getServices();







		$order = new Order(



			null,



			$services->getIterator()[0],



			new Address(



				'PL',



				'Johns Company',



				'Rynek 1',



				null,



				'50-116',



				'Wrocław',



				null,



				false,



				'John Smith',



				'mail@example.com',



				'123567890'



			),



			new Address(



				'PL',



				'Johns Company',



				'Rynek 1',



				null,



				'50-116',



				'Wrocław',



				null,



				false,



				'John Smith',



				'mail@example.com',



				'123567890'



			),



			new OrderStatusEnum(OrderStatusEnum::STATUS_NEW),



			new ShipmentCollection(



				new Shipment(new PackageTypeEnum(PackageTypeEnum::PACKAGE), 10, 10, 10, 10, false, 'Private package', 'Comment for the pack')



			),



			new Price(1000, 1230, null),



			'Private package',



			'Comment for the order'



		);







		$actual = $this->client->send($order);







		Assert::assertInstanceOf(Order::class, $actual);



		Assert::assertNotEmpty($actual->getId());







		return $actual;



	}







	/**



	 * @phpstan-ignore-next-line



	 */



	private function process_test_for_service_structure(CollectionInterface $collection, string $collectionElementClass): void



	{



		Assert::assertInstanceOf(CollectionInterface::class, $collection);



		Assert::assertFalse($collection->isEmpty());



		Assert::assertInstanceOf($collectionElementClass, $collection->getIterator()[0]);



	}







	/**



	 * @return array<string, PointTypeEnum[]>



	 */



	public function pointsTypesDataProvider(): array



	{



		$types = [];







		foreach (PointTypeEnum::getAllowed() as $type) {



			$types[sprintf('point type "%s" ', $type)] = [new PointTypeEnum($type)];



		}







		return $types;



	}







	/**



	 * @return array<string, string[]>



	 */



	public function ordersNumbersProvider(): array



	{



		return [



			'exists' => [



				'424549499'



			]



		];



	}



}



