<?php







declare(strict_types=1);







namespace Apaczka\Api\Client\Transformer;







use Apaczka\Api\Client\Model\Order;



use Apaczka\Api\Client\Model\Waybill;







class WaybillTransformer implements TransformerInterface



{



    /**



     * @param ?stdClass $object



     * @return ?Waybill



     */



    public function transform($object)



    {



        if (null === $object) {



            return null;



        }







        return new Waybill(



            base64_decode($object->waybill),



            $object->type



        );



    }







    /**



     * @param ?Waybill $object



     * @return ?stdClass



     */



    public function revert($object)



    {



        if (null === $object) {



            return null;



        }







        $s = new stdClass();



        $s->waybill = base64_encode($object->getContent());



        $s->type = $object->getType();







    }



}