<?php







declare(strict_types=1);







namespace Apaczka\Api\Client\Transformer;







use Apaczka\Api\Client\Model\UnitType;



use Apaczka\Api\Client\Model\UnitTypeEnum;



use stdClass;







/**



 * @implements TransformerInterface<?stdClass, ?UnitType>



 */



class UnitTypeTransformer implements TransformerInterface



{



	/**



	 * @param ?stdClass $object



	 * @return ?UnitType



	 */



	public function transform($object)



	{



		if (null === $object) {



			return null;



		}







		return new UnitType(



			new UnitTypeEnum($object->type),



			$object->desc



		);



	}







	/**



	 * @param ?UnitType $object



	 * @return ?stdClass



	 */



	public function revert($object)



	{



		if (null === $object) {



			return null;



		}







		$s = new stdClass();



		$s->type = (string) $object->getTypeEnum();



		$s->desc = $object->getDescription();







		return $s;



	}



}



