<?php







declare(strict_types=1);







namespace Apaczka\Api\Client\Transformer;







use Apaczka\Api\Client\Model\Service;



use stdClass;







/**



 * @implements TransformerInterface<?stdClass, ?Service>



 */



class ServiceTransformer implements TransformerInterface



{



	/**



	 * @param ?stdClass $object



	 * @return ?Service



	 */



	public function transform($object)



	{



		if (null === $object) {



			return null;



		}







		return new Service(



			(int) $object->service_id,



			isset($object->name) ? (string) $object->name : $object->service_name ?? '',



			$object->supplier ?? null,



			$object->delivery_time ?? null,



			isset($object->domestic) ? 1 === (int) $object->domestic : null,



			isset($object->pickup_courier) ? 1 === (int) $object->pickup_courier || 2 === (int) $object->pickup_courier  : null,



			isset($object->door_to_door) ? 1 === (int) $object->door_to_door : null,



			isset($object->door_to_point) ? 1 === (int) $object->door_to_point : null,



			isset($object->point_to_point) ? 1 === (int) $object->point_to_point : null,



			isset($object->point_to_door) ? 1 === (int) $object->point_to_door : null,



		);



	}







	/**



	 * @param ?Service $object



	 * @return ?stdClass



	 */



	public function revert($object)



	{



		if (null === $object) {



			return null;



		}







		$s = new stdClass();







		$s->service_id = (string) $object->getServiceId();



		$s->name = $object->getName();



		$s->supplier = $object->getSupplier();



		$s->domestic = $object->isDomestic() ? '1' : '0';



		if (null !== $object->getDeliveryTime()) {



			$s->delivery_time = $object->getDeliveryTime();



		}



		if (null !== $object->isPickupCourier()) {



			$s->pickup_courier = $object->isPickupCourier() ? '1' : '0';



		}



		if (null !== $object->isDoorToDoor()) {



			$s->door_to_door = $object->isDoorToDoor() ? '1' : '0';



		}



		if (null !== $object->isDoorToPoint()) {



			$s->door_to_point = $object->isDoorToPoint() ? '1' : '0';



		}



		if (null !== $object->isPointToPoint()) {



			$s->point_to_point = $object->isPointToPoint() ? '1' : '0';



		}



		if (null !== $object->isPointToDoor()) {



			$s->point_to_door = $object->isPointToDoor() ? '1' : '0';



		}







		return $s;



	}



}



