<?php







declare(strict_types=1);







namespace Apaczka\Api\Client\Transformer;







use Apaczka\Api\Client\Model\OptionCollection;



use Apaczka\Api\Client\Model\PackageType;



use Apaczka\Api\Client\Model\PackageTypeCollection;



use Apaczka\Api\Client\Model\PickupType;



use Apaczka\Api\Client\Model\PickupTypeCollection;



use Apaczka\Api\Client\Model\PickupTypeEnum;



use Apaczka\Api\Client\Model\PointTypeCollection;



use Apaczka\Api\Client\Model\PointTypeEnum;



use Apaczka\Api\Client\Model\Service;



use Apaczka\Api\Client\Model\ServiceCollection;



use Apaczka\Api\Client\Model\ServiceStructure;



use Apaczka\Api\Client\Model\UnitType;



use Apaczka\Api\Client\Model\UnitTypeCollection;



use stdClass;







/**



 * @implements TransformerInterface<?stdClass, ?ServiceStructure>



 */



class ServiceStructureTransformer implements TransformerInterface



{



	/**



	 * @var CollectionTransformer<stdClass, UnitType>



	 */



	private CollectionTransformer $unitTypeCollectionTransformer;







	/**



	 * @var CollectionTransformer<stdClass, PickupType>



	 */



	private CollectionTransformer $pickupTypeCollectionTransformer;







	/**



	 * @var CollectionTransformer<string, PointTypeEnum>



	 */



	private CollectionTransformer $pointTypeCollectionTransformer;







	/**



	 * @var CollectionTransformer<stdClass, PackageType>



	 */



	private CollectionTransformer $packageTypeCollectionTransformer;



	/**



	 * @var CollectionTransformer<stdClass, Service>



	 */



	private CollectionTransformer $serviceCollectionTransformer;



	private OptionCollectionTransformer $optionCollectionTransformer;







	public function __construct()



	{



		$this->unitTypeCollectionTransformer = new CollectionTransformer(



			new UnitTypeTransformer(),



			new UnitTypeCollection()



		);



		$this->pickupTypeCollectionTransformer = new CollectionTransformer(



			new PickupTypeTransformer(),



			new PickupTypeCollection()



		);



		$this->pointTypeCollectionTransformer = new CollectionTransformer(



			new PointTypeTransformer(),



			new PointTypeCollection()



		);



		$this->packageTypeCollectionTransformer = new CollectionTransformer(



			new PackageTypeTransformer(),



			new PackageTypeCollection()



		);



		$this->serviceCollectionTransformer = new CollectionTransformer(



			new ServiceTransformer(),



			new ServiceCollection()



		);



		$this->optionCollectionTransformer = new OptionCollectionTransformer(



			new OptionTransformer(),



			new OptionCollection()



		);



	}







	/**



	 * @param ?stdClass $object



	 * @return ?ServiceStructure



	 */



	public function transform($object)



	{



		if (null === $object) {



			return null;



		}







		return new ServiceStructure(



			$this->unitTypeCollectionTransformer->transform($object->unit_type),



			$this->pickupTypeCollectionTransformer->transform($object->pickup_type),



			$this->pointTypeCollectionTransformer->transform($object->points_type),



			$this->packageTypeCollectionTransformer->transform($object->package_type),



			$this->serviceCollectionTransformer->transform($object->services),



			$this->optionCollectionTransformer->transform($object->options)



		);



	}







	/**



	 * @param ?ServiceStructure $object



	 * @return ?stdClass



	 */



	public function revert($object)



	{



		if (null === $object) {



			return null;



		}







		$s = new stdClass();







		$s->unit_type = $this->unitTypeCollectionTransformer->revert($object->getUnitTypes());



		$s->pickup_type = $this->pickupTypeCollectionTransformer->revert($object->getPickupTypes());



		$s->points_type = $this->pointTypeCollectionTransformer->revert($object->getPointTypes());



		$s->package_type = $this->packageTypeCollectionTransformer->revert($object->getPackageTypes());



		$s->services = $this->serviceCollectionTransformer->revert($object->getServices());



		$s->options = $this->optionCollectionTransformer->revert($object->getOptions());







		return $s;



	}



}



