<?php







declare(strict_types=1);



namespace Apaczka\Api\Client\Transformer;







use Apaczka\Api\Client\Model\Address;



use Apaczka\Api\Client\Model\Image;



use Apaczka\Api\Client\Model\OpenHours;



use Apaczka\Api\Client\Model\Point;



use Apaczka\Api\Client\Model\PointTypeEnum;



use Apaczka\Api\Client\Model\WeekOpenHours;



use GuzzleHttp\Psr7\Uri;



use stdClass;







/**



 * @implements TransformerInterface<?stdClass, ?Point>



 */



class PointTransformer implements TransformerInterface



{



	private AddressTransformer $addressTransformer;







	public function __construct()



	{



		$this->addressTransformer = new AddressTransformer();



	}







	public function transform($object)



	{



		if (null === $object) {



			return null;



		}







		$address = new Address();







		if (isset($object->address)) {



			$object->address->id = $object->foreign_address_id;



			$address = $this->addressTransformer->transform($object->address);



		}







		$weekOpenHours = new WeekOpenHours();



		if (isset($object->open_hours)) {



			$openHours = $object->open_hours;







			$weekOpenHours = new WeekOpenHours(



				isset($openHours->mon) ? new OpenHours($openHours->mon[0][0], $openHours->mon[0][1]) : null,



				isset($openHours->tue) ? new OpenHours($openHours->tue[0][0], $openHours->tue[0][1]) : null,



				isset($openHours->wed) ? new OpenHours($openHours->wed[0][0], $openHours->wed[0][1]) : null,



				isset($openHours->thu) ? new OpenHours($openHours->thu[0][0], $openHours->thu[0][1]) : null,



				isset($openHours->fri) ? new OpenHours($openHours->fri[0][0], $openHours->fri[0][1]) : null,



				isset($openHours->sat) ? new OpenHours($openHours->sat[0][0], $openHours->sat[0][1]) : null,



				isset($openHours->sun) ? new OpenHours($openHours->sun[0][0], $openHours->sun[0][1]) : null,



			);



		}







		return new Point(



			$object->id,



			new PointTypeEnum($object->type),



			$object->name ?? '',



			$address,



			$weekOpenHours,



			$object->option_cod ? (bool) $object->option_cod : false,



			$object->option_send ? (bool) $object->option_send : false,



			$object->option_deliver ? (bool) $object->option_deliver : false,



			$object->distance ? (int) $object->distance : 0,



			isset($object->image_url) ? new Image(new Uri($object->image_url)) : null,



			$object->additional_info ?? null,



		);



	}







	/**



	 * @param ?Point $object



	 * @return ?stdClass



	 */



	public function revert($object)



	{



		if (null === $object) {



			return null;



		}







		$s = new stdClass();



		$s->id = $object->getId();







		$s->type = (string) $object->getType();



		$s->name = $object->getName();



		$s->address = $this->addressTransformer->revert($object->getAddress());



		$s->foreign_address_id = (string) $object->getAddress()->getForeignAddressId();



		$s->image_url = null !== $object->getImage() ? (string) $object->getImage()->getPath() : '';



		$s->option_cod = $object->hasCashOnDeliveryOption();



		$s->option_send = $object->hasSendOption();



		$s->option_deliver = $object->hasDeliverOption();



		$s->distance = $object->getDistance();



		$s->additional_info = $object->getAdditionalInfo();







		$weekOpenHours = $object->getWeekOpenHours();



		$s->open_hours = new stdClass();



		$s->open_hours->mon = null === $weekOpenHours->getMonday() ? [] : [ [$weekOpenHours->getMonday()->getFrom(), $weekOpenHours->getMonday()->getTo()] ];



		$s->open_hours->tue = null === $weekOpenHours->getTuesday() ? [] : [ [$weekOpenHours->getTuesday()->getFrom(), $weekOpenHours->getTuesday()->getTo()] ];



		$s->open_hours->wed = null === $weekOpenHours->getWednesday() ? [] : [ [$weekOpenHours->getWednesday()->getFrom(), $weekOpenHours->getThursday()->getTo()] ];



		$s->open_hours->thu = null === $weekOpenHours->getThursday() ? [] : [ [$weekOpenHours->getThursday()->getFrom(), $weekOpenHours->getThursday()->getTo()] ];



		$s->open_hours->fri = null === $weekOpenHours->getFriday() ? [] : [ [$weekOpenHours->getFriday()->getFrom(), $weekOpenHours->getFriday()->getTo()] ];



		$s->open_hours->sat = null === $weekOpenHours->getSaturday() ? [] : [ [$weekOpenHours->getSaturday()->getFrom(), $weekOpenHours->getSaturday()->getTo()] ];



		$s->open_hours->sun = null === $weekOpenHours->getSunday() ? [] : [ [$weekOpenHours->getSunday()->getFrom(), $weekOpenHours->getSunday()->getTo()] ];







		return $s;



	}



}



