<?php







declare(strict_types=1);







namespace Apaczka\Api\Client\Transformer;







use Apaczka\Api\Client\Helper\Compositor;



use Apaczka\Api\Client\Model\Order;



use Apaczka\Api\Client\Model\OrderStatusEnum;



use Apaczka\Api\Client\Model\Shipment;



use Apaczka\Api\Client\Model\ShipmentCollection;



use DateTimeImmutable;



use DateTimeInterface;



use GuzzleHttp\Psr7\Uri;



use stdClass;







/**



 * @implements TransformerInterface<?stdClass, ?Order>



 */



class OrderTransformer implements TransformerInterface



{



	private ServiceTransformer $serviceTransformer;



	private AddressTransformer $addressTransformer;



	private PickupTransformer $pickupTransformer;



	private PriceTransformer $priceTransformer;



	/**



	 * @var CollectionTransformer<stdClass, Shipment>



	 */



	private CollectionTransformer $shipmentCollectionTransformer;







	public function __construct()



	{



		$this->serviceTransformer = new ServiceTransformer();



		$this->addressTransformer = new AddressTransformer();



		$this->pickupTransformer = new PickupTransformer();



		$this->priceTransformer = new PriceTransformer();



		$this->shipmentCollectionTransformer = new CollectionTransformer(



			new ShipmentTransformer(),



			new ShipmentCollection(),



		);



	}







	/**



	 * @param ?stdClass $object



	 * @return ?Order



	 */



	public function transform($object)



	{



		if (null === $object) {



			return null;



		}







		if (isset($object->pickup) && is_object($object->pickup)) {



			$object->pickup->pickup_number = $object->pickup_number;



		}







		return new Order(



			(string) $object->id,



			$this->serviceTransformer->transform($object),



			isset($object->sender) ? $this->addressTransformer->transform($object->sender) : null,



			isset($object->receiver) ? $this->addressTransformer->transform($object->receiver) : null,



			isset($object->status) ? new OrderStatusEnum($object->status) : null,



			isset($object->shipments)



				? $this->shipmentCollectionTransformer->transform($object->shipments)



				: new ShipmentCollection(),



			$this->priceTransformer->transform($object),



			$object->content,



			$object->comment,



			$object->waybill_number,



			isset($object->pickup) ? $this->pickupTransformer->transform($object->pickup) : null,



			null !== $object->tracking_url ? new Uri($object->tracking_url) : null,



			null !== $object->created ? new DateTimeImmutable($object->created) : null,



			null !== $object->delivered ? new DateTimeImmutable($object->delivered) : null,



			isset($object->cod) ? (bool) $object->cod : false,



            isset($object->cod) && isset($object->cod->amount) ? $object->cod->amount : null,



            isset($object->cod) && isset($object->cod->bankaccount) ? $object->cod->bankaccount: null,



			isset($object->declaration_value)  && isset($object->cod->declaration_value)  ? (bool) $object->declaration_value : false,



		);



	}







	/**



	 * @param ?Order $object



	 * @return ?stdClass



	 */



	public function revert($object)



	{



		if (null === $object) {



			return null;



		}







		$s = new stdClass();



		//$s->id = $object->getId();



		if (null !== $object->getService()) {



			//$s->supplier = $object->getService()->getSupplier();



			$s->service_id = $object->getService()->getServiceId();



			//$s->service_name = $object->getService()->getName();



		}



		//$s->waybill_number = $object->getWaybillNumber();



		if (null !== $object->getPickup()) {



			$s->pickup = $this->pickupTransformer->revert($object->getPickup());



			//$s->pickup_number = $object->getPickup()->getNumber();



		}



		//Compositor::compose($s, $this->priceTransformer->revert($object->getPrice()));



		//$s->tracking_url = (string) $object->getTrackingUrl();



		//$s->status = (string) $object->getStatus();



		//$s->shipments_count = $object->getShipmentCollection()->getSize();



        $s->shipment_value = $object->getPrice()->getGross();



		$s->shipments = $this->shipmentCollectionTransformer->revert($object->getShipmentCollection());



		$s->content = $object->getContent();



		$s->comment = $object->getComment();







        $s->address = new stdClass();



		$s->address->sender = $this->addressTransformer->revert($object->getSender());



		$s->address->receiver = $this->addressTransformer->revert($object->getReceiver());







        if ($object->isCashOnDelivery()) {



            $s->cod = new stdClass();



            $s->cod->amount = $object->getCashOnDeliveryAmount();



            $s->cod->bankaccount =  preg_replace('/[^0-9]/', '', $object->getBankAccountNumber());



        }



        //$s->created = (null !== $object->getCreated()) ? $object->getCreated()->format(DateTimeInterface::RFC3339) : null;



		//$s->delivered = (null !== $object->getDelivered()) ? $object->getCreated()->format(DateTimeInterface::RFC3339) : null;







        //Compositor::compose($s, $this->priceTransformer->revert($object->getPrice()));



		//$s->declaration_value = $object->isDeclarationValue();







		return $s;



	}



}



