<?php







declare(strict_types=1);







namespace Apaczka\Api\Client\Transformer;







use Apaczka\Api\Client\Common\CollectionInterface;







/**



 * @template T



 * @template R



 * @implements TransformerInterface<?iterable<T>, ?CollectionInterface<R>>



 */



class CollectionTransformer implements TransformerInterface



{



	/**



	 * @var TransformerInterface<?T, ?R>



	 */



	private TransformerInterface $transformer;



	/**



	 * @var CollectionInterface<R>



	 */



	private CollectionInterface $collection;







	/**



	 * @param TransformerInterface<?T, ?R> $transformer



	 * @param CollectionInterface<R> $collection



	 */



	public function __construct(



		TransformerInterface $transformer,



		CollectionInterface $collection



	) {



		$this->transformer = $transformer;



		$this->collection = $collection;



	}







	/**



	 * @param ?iterable<T> $items



	 * @return CollectionInterface<R>



	 */



	public function transform($items): CollectionInterface



	{



		if (null === $items) {



			return $this->collection;



		}







		foreach ($items as $item) {



			$this->collection->add(



				$this->transformer->transform($item)



			);



		}







		return $this->collection;



	}







	/**



	 * @param ?CollectionInterface<R> $collection



	 * @return ?iterable<T>



	 */



	public function revert($collection)



	{



		if (null === $collection) {



			return null;



		}



		$elements = [];







		foreach ($collection as $element) {



			$elements[] = $this->transformer->revert($element);



		}







		return $elements;



	}



}



