<?php







declare(strict_types=1);







namespace Apaczka\Api\Client\Model;







use DateTimeInterface;







class Pickup



{



	private PickupTypeEnum $typeEnum;



	private ?DateTimeInterface $day;



	private ?string $hourFrom;



	private ?string $hoursTo;



	private ?int $addressId;



	private ?string $number;







	public function __construct(



		PickupTypeEnum     $typeEnum,



		?DateTimeInterface $day = null,



		?string            $hourFrom = null,



		?string            $hoursTo = null,



		?int               $addressId = null,



		?string            $number = null



	) {



		$this->typeEnum = $typeEnum;



		$this->day = $day;



		$this->hourFrom = $hourFrom;



		$this->hoursTo = $hoursTo;



		$this->addressId = $addressId;



		$this->number = $number;



	}







	public function getNumber(): ?string



	{



		return $this->number;



	}







	public function getTypeEnum(): PickupTypeEnum



	{



		return $this->typeEnum;



	}







	public function getDay(): ?DateTimeInterface



	{



		return $this->day;



	}







	public function getHourFrom(): ?string



	{



		return $this->hourFrom;



	}







	public function getHoursTo(): ?string



	{



		return $this->hoursTo;



	}







	public function getAddressId(): ?int



	{



		return $this->addressId;



	}



}



