<?php







declare(strict_types=1);







namespace Apaczka\Api\Client\Model;







use Apaczka\Api\Client\Common\BaseEnum;







class PackageTypeEnum extends BaseEnum



{



	public const LETTER = 'LIST';



	public const PACKAGE = 'PACZKA';



	public const PALLET = 'PALETA';



	public const HALF_PALLET = 'POLPALETA';



	public const INDUSTRIAL_PALLET = 'PALETA_PRZEMYSLOWA';



	public const INDUSTRIAL_PALLET_B = 'PALETA_PRZEMYSLOWA_B';







    private const PALLETS = [



        self::PALLET,



        self::HALF_PALLET,



        self::INDUSTRIAL_PALLET,



        self::INDUSTRIAL_PALLET_B



    ];







	public static function getAllowed(): array



	{



		return [



		   self::LETTER,



		   self::PACKAGE,



		   self::PALLET,



		   self::HALF_PALLET,



		   self::INDUSTRIAL_PALLET,



		   self::INDUSTRIAL_PALLET_B,



		];



	}







    public function isPallet(): bool



    {



        return in_array((string) $this, self::PALLETS, true);



    }



}



