<?php







declare(strict_types=1);







namespace Apaczka\Api\Client\Mapper;







use GuzzleHttp\Message\Request as GuzzleHttp5Request;



use GuzzleHttp\Message\RequestInterface as GuzzleHttpRequestInterface;



use GuzzleHttp\Stream\Stream;



use Psr\Http\Message\RequestInterface as PsrRequestInterface;







class PsrToGuzzle5RequestMapper



{



	/**



	 * @param array<string, string|bool|int|float|null> $options



	 */



	public function map(PsrRequestInterface $psrRequest, array $options = []): GuzzleHttpRequestInterface



	{



		return new GuzzleHttp5Request(



			$psrRequest->getMethod(),



			(string) $psrRequest->getUri(),



			$psrRequest->getHeaders(),



			Stream::factory($psrRequest->getBody()->getContents()),



			$options



		);



	}



}



