<?php







declare(strict_types=1);







namespace Apaczka\Api\Client\Mapper;







use Apaczka\Api\Client\Http\Factory\StreamFactory;



use GuzzleHttp\Message\ResponseInterface as GuzzleHttp5Response;



use GuzzleHttp\Psr7\Response;



use Psr\Http\Message\ResponseInterface as PsrResponseInterface;







class Guzzle5ToPsrResponseMapper



{



	public function map(GuzzleHttp5Response $response): PsrResponseInterface



	{



		$streamFactory = new StreamFactory();







		return new Response(



			$response->getStatusCode(),



			$response->getHeaders(),



			$streamFactory->createStream($response->getBody()->getContents()),



			$response->getProtocolVersion(),



			$response->getReasonPhrase()



		);



	}



}



