<?php







declare(strict_types=1);







namespace Apaczka\Api\Client\Http\Processor;







use Apaczka\Api\Client\Exception\HttpClientRequestProcessorException;



use GuzzleHttp\ClientInterface;







class RequestProcessorProvider implements RequestProcessorProviderInterface



{



	private ClientInterface $client;







	public function __construct(ClientInterface $client)



	{



		$this->client = $client;



	}







	public function getProcessor(): RequestProcessorInterface



	{



		if (version_compare($this->client::VERSION, '7.0.0', '>=')) {



			return new RequestProcessorGuzzleV7($this->client);



		}







		if (version_compare($this->client::VERSION, '5.0.0', '>=')) {



			return new RequestProcessorGuzzleV5($this->client);



		}







		throw HttpClientRequestProcessorException::providerNotFoundForClientVersion($this->client::VERSION);



	}



}



