<?php







declare(strict_types=1);







namespace Apaczka\Api\Client\Http\Processor;







use Apaczka\Api\Client\Http\Exception\HttpBadRequestException;



use Apaczka\Api\Client\Mapper\Guzzle5ToPsrResponseMapper;



use Apaczka\Api\Client\Mapper\PsrToGuzzle5RequestMapper;



use GuzzleHttp\ClientInterface;



use GuzzleHttp\Exception\RequestException;



use Psr\Http\Message\RequestInterface;



use Psr\Http\Message\ResponseInterface;







class RequestProcessorGuzzleV5 implements RequestProcessorInterface



{



	private ClientInterface $client;







	public function __construct(ClientInterface $client)



	{



		$this->client = $client;



	}







	public function process(RequestInterface $request, int $successCode = 200): ResponseInterface



	{



		try {



			$request = (new PsrToGuzzle5RequestMapper())->map($request, ['verify' => false]);



			$response = $this->client->send($request);







			return (new Guzzle5ToPsrResponseMapper())->map($response);



		} catch (RequestException $e) {



			throw new HttpBadRequestException($e->getMessage(), $e->getCode());



		}



	}



}



