<?php







declare(strict_types=1);







namespace Apaczka\Api\Client\Http\Plugin;







use Psr\Http\Message\RequestInterface;



use Psr\Http\Message\ResponseInterface;



use Psr\Log\LoggerInterface;







class LoggerPlugin implements PluginInterface



{



	private LoggerInterface $logger;







	public function __construct(LoggerInterface $logger)



	{



		$this->logger = $logger;



	}







	public function handleRequest(RequestInterface $request): RequestInterface



	{



        $content = $request->getBody()->getContents();







		$this->log(



			sprintf('Request %s %s', $request->getMethod(), $request->getUri()),



			[



				'headers' => $request->getHeaders(),



                'url' =>  (string) $request->getUri(),



				'body' => json_decode($content, true),



			]



		);







		$request->getBody()->rewind();







		return $request;



	}







	public function handleResponse(RequestInterface $request, ResponseInterface $response): ResponseInterface



	{



		$this->log(



			sprintf('Response %s %s %s', $request->getMethod(), $request->getUri(), $response->getStatusCode()),



			[



				'headers' => $response->getHeaders(),



				'body' => json_decode($response->getBody()->getContents(), true),



			]



		);







		$response->getBody()->rewind();







		return $response;



	}







	/**



	 * @param mixed[] $context



	 */



	private function log(string $message, array $context = []): void



	{



		$this->logger->debug(



			sprintf("[%d]: %s", getmypid(), $message),



			$context



		);



	}



}



