<?php







declare(strict_types=1);



namespace Apaczka\Api\Client\Http\Factory;







use GuzzleHttp\Psr7;



use Psr\Http\Message\StreamFactoryInterface;



use Psr\Http\Message\StreamInterface;







class StreamFactory implements StreamFactoryInterface



{



	public function createStream(string $content = ''): StreamInterface



	{



		return Psr7\Utils::streamFor($content);



	}







	public function createStreamFromFile(string $filename, string $mode = 'r'): StreamInterface



	{



		return $this->createStreamFromResource(



			Psr7\Utils::tryFopen($filename, $mode)



		);



	}







	public function createStreamFromResource($resource): StreamInterface



	{



		return Psr7\Utils::streamFor($resource);



	}



}



