<?php







declare(strict_types=1);







namespace Apaczka\Api\Client\Helper;







use stdClass;







class DataTransformerHelper



{



	/**



	 * @param array<string, ?string> $map



	 * @return stdClass



	 */



	public static function remapKeys(stdClass $object, array $map): stdClass



	{



		foreach ($map as $oldProperty => $newProperty) {



			if (!property_exists($object, $oldProperty)) {



				continue;



			}



			$current = $object->{$oldProperty};



			unset($object->{$oldProperty});







			if (null === $newProperty) {



				continue;



			}



			$object->{$newProperty} = $current;



		}







		return $object;



	}



}



