<?php







declare(strict_types=1);







namespace Apaczka\Api\Client\Common;







use InvalidArgumentException;







abstract class BaseEnum



{



	private string $name;







	final public function __construct(string $name)



	{



		$this->guardName($name);



		$this->name = $name;



	}







	/**



	 * @return string[]



	 */



	abstract public static function getAllowed(): array;







    public function __toString(): string



    {



        return $this->name;



    }







    public function __serialize(): array



    {



        return [



            'name' => $this->name



        ];



    }







    public function __unserialize(array $data): void



    {



        $this->name = $data['name'] ?? '';



        $this->guardName($this->name);



    }







	private function guardName(string $name): void



	{



		if (!in_array($name, static::getAllowed(), true)) {



			throw new InvalidArgumentException(



				sprintf(



					'The given name "%s" is invalid for "%s". Allowed are: %s',



					$name,



					static::class,



					implode(', ', static::getAllowed())



				)



			);



		}



	}











}



