<?php







declare(strict_types=1);







namespace Apaczka\Api\Client\Common;







use Apaczka\Api\Client\Exception\InvalidArgumentException;



use ArrayIterator;



use Iterator;







/**



 * @template TValue



 * @implements  CollectionInterface<TValue>



 */



abstract class BaseCollection implements CollectionInterface



{



	/**



	 * @var TValue[]



	 */



	private array $elements = [];







	abstract public function getAllowedType(): string;







	/**



	 * @param TValue[] $elements



	 */



	public function __construct(...$elements)



	{



		foreach ($elements as $element) {



			$this->add($element);



		}



	}







	/**



	 * @param TValue $element



	 */



	public function add($element): void



	{



		$this->guardAllowed($element);







		$this->elements[] = $element;



	}







	public function getSize(): int



	{



		return count($this->elements);



	}







	public function count(): int



	{



		return $this->getSize();



	}







	public function isEmpty(): bool



	{



		return 0 === $this->getSize();



	}







	public function getIterator(): Iterator



	{



		return new ArrayIterator($this->elements);



	}







	protected function guardAllowed(object $element): void



	{



		if (is_a($element, $this->getAllowedType())) {



			return;



		}







		throw new InvalidArgumentException(



			sprintf('Type "%s" is not allowed for the collection "%s". Only "%s" is allowed', get_class($element), static::class, $this->getAllowedType())



		);



	}







    public function __serialize(): array



    {



        $data = [];







        foreach ($this->elements as $e) {



            $data[] = $e->__serialize();



        }







        return $data;



    }



}



