<?php







declare(strict_types=1);







namespace Apaczka\Api\Client;







use Apaczka\Api\Client\Http\Factory\RequestFactory;



use Apaczka\Api\Client\Http\Factory\StreamFactory;



use Apaczka\Api\Client\Http\HttpClient;



use Apaczka\Api\Client\Http\Plugin\LoggerPlugin;



use Apaczka\Api\Client\Http\Plugin\PluginInterface;



use Apaczka\Api\Client\Http\Plugin\SingRequestPlugin;



use Apaczka\Api\Client\Http\Processor\RequestProcessorProvider;



use Apaczka\Api\Client\Settings\Settings;



use GuzzleHttp\Client;



use Psr\Log\LoggerInterface;







class ApiClientFactory



{



	public static function createDefault(string $apiId, string $apiSecret, ?LoggerInterface $logger = null): ApiClient



	{



		$settings = new Settings($apiId, $apiSecret);



        $plugins = self::getPlugins($settings, $logger);







		$httpClient = new HttpClient(



			new RequestProcessorProvider(new Client()),



			new RequestFactory(),



			new StreamFactory(),



            ...$plugins



		);







		return new ApiClient($settings, $httpClient);



	}







    /**



     * @return PluginInterface[]



     */



    private static function getPlugins(Settings $settings, ?LoggerInterface $logger = null): array



    {



        $plugins = [];







        if (null !== $logger) {



            $plugins[] = new LoggerPlugin($logger);



        }







        $plugins[] = new SingRequestPlugin(



            $settings,



            new StreamFactory()



        );







        return $plugins;



    }



}



