<?php







declare(strict_types=1);







namespace Apaczka\Prestashop\Service;







use Apaczkashipments;



use Apaczka\Prestashop\Config\ModuleConfigInterface;







class SetupService



{



    private ModuleConfigInterface $config;







    public function __construct(ModuleConfigInterface $config)



    {



        $this->config = $config;



    }







    public function start(Apaczkashipments $module): void



    {



        $module->bootstrap = true;



        $module->name = $this->config->getModuleName();



        $module->tab  = $this->config->getModuleTab();



        $module->version = $this->config->getModuleVersion();



        $module->author = $this->config->getModuleAuthor();



        $module->need_instance = true === $this->config->isNeedInstance() ? 1 : 0;



        $module->ps_versions_compliancy = [



            'min' => $this->config->getMinSupportedPrestashopVersion(),



            'max' => $this->config->getMaxSupportedPrestashopVersion(),



        ];







    }







    public function finish(Apaczkashipments $module): void



    {



        $module->displayName = $module->l('Przesyłki Apaczka.pl');



        $module->description = $module->l('Wtyczka "Apaczka" to niezastąpione narzędzie dla właścicieli sklepów internetowych opartych na platformie PrestaShop w wersji 1.7. Pozwala ona na łatwe i efektywne zarządzanie dostawą i wysyłką zamówień, co sprawia, że Twoja działalność e-commerce staje się bardziej efektywna i konkurencyjna.');



    }



}