<?php





declare(strict_types=1);





namespace Apaczka\Prestashop\Service;





use Apaczka\Api\Client\Model\PointTypeEnum;


use Doctrine\ORM\EntityManagerInterface;


use Module;





class MapOrderedPointService


{


    private const APACZKA_MAP_MODULE_NAME = 'apaczka';


    private EntityManagerInterface $entityManager;





    public function __construct(EntityManagerInterface $entityManager)


    {


        $this->entityManager = $entityManager;


    }





    /**


     * @return array{point: string|null, supplier: string|null}|null


     */


    public function getOrderedPoint(int $psOrderId): ?array


    {


        if (!$this->isApaczkaModuleMapInstalled()) {


            return null;


        }





        $data = $this->getOrderedPointData($psOrderId);


        if (null === $data || empty($data['point']) || empty($data['supplier'])) {


            return null;


        }





        $type = mb_strtoupper($data['supplier']);


        if (!in_array($type, PointTypeEnum::getAllowed(), true)) {


            return null;


        }





        return $data;


    }





    private function isApaczkaModuleMapInstalled(): bool


    {


        return 0 < Module::getModuleIdByName(self::APACZKA_MAP_MODULE_NAME);


    }





    /**


     * @return array{point: string|null, supplier: string|null}|null


     */


    private function getOrderedPointData(int $psOrderId): ?array


    {


        $data = $this->entityManager->getConnection()


            ->fetchAssoc(sprintf('select apaczka_supplier as supplier, apaczka_point as point from %sorders where id_order = %d',_DB_PREFIX_, $psOrderId));





        return is_array($data) ? $data : null;


    }


}