<?php





declare(strict_types=1);





namespace Apaczka\Prestashop\Service\Install;





use Apaczka\Prestashop\Config\ModuleConfigInterface;


use Apaczka\Prestashop\Service\InstallerInterface;





class TranslationsInstaller implements InstallerInterface


{


    private ModuleConfigInterface $config;


    private static array $translations = [


        'default/ModulesApaczkashipmentsAdmin.xlf',


        'en-US/ModulesApaczkashipmentsAdmin.en-US.xlf',


        'pl-PL/ModulesApaczkashipmentsAdmin.pl-PL.xlf'


    ];





    public function __construct(ModuleConfigInterface $config)


    {


        $this->config = $config;


    }





    public function install(): bool


    {


        return true;





       $src = implode(DIRECTORY_SEPARATOR, [$this->config->getModuleDirectory(), 'translations']) . DIRECTORY_SEPARATOR;


       $dst = rtrim(implode(DIRECTORY_SEPARATOR, [


               _PS_ROOT_DIR_,


               'app',


               'Resources',


               'translations'


           ]), DIRECTORY_SEPARATOR) . DIRECTORY_SEPARATOR;








        foreach (self::$translations as $translation) {


            $srcTranslation = $src . $translation;


            $dstTranslation = $dst . $translation;





            if (!is_file($srcTranslation)) {


                throw new \Exception('file not found ' . $srcTranslation);


            }








            $dstDir = dirname($dstTranslation);


            if (!is_dir($dstDir)) {


                continue;


            }





            if (is_file($dstTranslation) && is_writable($dstTranslation)) {


                unlink($dstTranslation);


            }





            copy($srcTranslation, $dstTranslation);


        }





        return true;


    }


}