<?php





declare(strict_types=1);





namespace Apaczka\Prestashop\Service\Install;





use Apaczka\Prestashop\Config\ModuleConfigInterface;


use Apaczka\Prestashop\Service\InstallerInterface;


use Db;





class DbSchemaInstaller implements InstallerInterface


{


    private ModuleConfigInterface $config;





    public function __construct(ModuleConfigInterface $config)


    {


        $this->config = $config;


    }





    public function install(): bool


    {


        $src = implode(DIRECTORY_SEPARATOR, [$this->config->getModuleDirectory(), 'sql', 'install.sql']);





        $sql = str_replace([


            'DB_PREFIX_',


            'DB_ENGINE_TYPE'


        ], [


            _DB_PREFIX_,


            _MYSQL_ENGINE_


        ], file_get_contents($src));


        $sql = preg_split("/;\s*[\r\n]+/", trim($sql));





        foreach ($sql as $query) {


            if (!Db::getInstance()->execute(trim($query), true)) {


                return false;


            }


        }





        return true;


    }


}