<?php





declare(strict_types=1);





namespace Apaczka\Prestashop\Repository\InConfiguration;





use Apaczka\Prestashop\Model\ServicesRepositoryInterface;


use Apaczka\Prestashop\Provider\DeliveryServicesProvider;


use PrestaShop\PrestaShop\Adapter\Configuration;





class ServicesRepository implements ServicesRepositoryInterface


{


    private const CONFIGURATION_CHOSEN_KEY = 'APACZKA_SETTINGS_CHOSEN_SERVICES';


    private const CONFIGURATION_AVAILABLE_KEY = 'APACZKA_SETTINGS_AVAILABLE_SERVICES';





    private Configuration $configuration;


    private DeliveryServicesProvider $deliveryServicesProvider;





    public function __construct(


        Configuration $configuration,


        DeliveryServicesProvider $deliveryServicesProvider


    )


    {


        $this->configuration = $configuration;


        $this->deliveryServicesProvider = $deliveryServicesProvider;


    }





    public function getOptions(bool $useCache = true): array


    {


        if (!$useCache || !$this->configuration->has(self::CONFIGURATION_AVAILABLE_KEY)) {


            $options = $this->deliveryServicesProvider->getOptions();


            $this->configuration->set(self::CONFIGURATION_AVAILABLE_KEY, serialize($options));


            $this->saveChosen(array_keys($options));


        }





        $options = unserialize($this->configuration->get(self::CONFIGURATION_AVAILABLE_KEY));


        if (!is_array($options)) {


            return [];


        }





        return $options;


    }





    /**


     * @param int[] $servicesIds


     */


    public function saveChosen(array $servicesIds): void


    {


        $this->configuration->set(self::CONFIGURATION_CHOSEN_KEY, serialize($servicesIds));


    }





    /**


     * @return int[]


     */


    public function getChosen(): array


    {


        if (!$this->configuration->has(self::CONFIGURATION_CHOSEN_KEY)) {


            return array_keys($this->getOptions());


        }





        $data = unserialize($this->configuration->get(self::CONFIGURATION_CHOSEN_KEY));


        if (!is_array($data) || empty($data)) {


            return array_keys($this->getOptions());


        }





        return array_map('intval', $data);


    }





    public function getChosenOptions(): array


    {


        $options = $this->getOptions();


        $chosen = $this->getChosen();





        return array_filter($options, function($key) use ($chosen) {


            return in_array($key, $chosen, true);


        }, ARRAY_FILTER_USE_KEY);


    }


}