<?php





declare(strict_types=1);





namespace Apaczka\Prestashop\Repository\InConfiguration;





use Apaczka\Prestashop\Model\SendingPoints;


use Apaczka\Prestashop\Model\SendingPointsRepositoryInterface;


use PrestaShop\PrestaShop\Adapter\Configuration;





class SendingPointsRepository implements SendingPointsRepositoryInterface


{


    private const CONFIGURATION_KEY = 'APACZKA_SETTINGS_POINTS';





    private Configuration $configuration;





    public function __construct(Configuration $configuration)


    {


        $this->configuration = $configuration;


    }





    public function save(SendingPoints $points): void


    {


        $this->configuration->set(self::CONFIGURATION_KEY, serialize($points));


    }





    public function get(): ?SendingPoints


    {


        if (!$this->configuration->has(self::CONFIGURATION_KEY)) {


            return null;


        }





       return unserialize($this->configuration->get(self::CONFIGURATION_KEY));


    }


}