<?php





declare(strict_types=1);





namespace Apaczka\Prestashop\Provider;





use Apaczka\Api\Client\ApiClient;


use Apaczka\Api\Client\ApiClientFactory;


use Apaczka\Prestashop\Config\ModuleConfig;


use Apaczka\Prestashop\Config\ModuleConfigInterface;


use Apaczka\Prestashop\Service\Install\DbSchemaInstaller;


use Apaczka\Prestashop\Service\Install\TranslationsInstaller;


use Apaczka\Prestashop\Service\InstallService;


use Apaczka\Prestashop\Service\SetupService;


use Apaczka\Prestashop\Service\UninstallService;


use Monolog\Handler\StreamHandler;


use Monolog\Logger;


use PrestaShop\PrestaShop\Adapter\SymfonyContainer;


use Psr\Log\LoggerInterface;


use Symfony\Bundle\TwigBundle\TwigEngine;


use Symfony\Component\DependencyInjection\ContainerInterface;





class ServiceProvider


{


    private static ServiceProvider $instance;


    private ContainerInterface $container;





    public function __construct(ContainerInterface $container)


    {


        $this->container = $container;


    }





    public static function getInstance(): self


    {


        if (!isset(self::$instance)) {


            self::$instance = new self(SymfonyContainer::getInstance());


        }





        return self::$instance;


    }





    public function getSetupService(): SetupService


    {


        static $instance;


        if (!isset($instance)) {


            $instance = new SetupService($this->getModuleConfig());


        }





        return $instance;


    }





    public function getInstallService(): InstallService


    {


        static $instance;


        if (!isset($instance)) {


            $instance = new InstallService(


                new TranslationsInstaller($this->getModuleConfig()),


                new DbSchemaInstaller($this->getModuleConfig())


            );


        }





        return $instance;


    }





    public function getUninstallService(): UninstallService


    {


        static $instance;


        if (!isset($instance)) {


            $instance = new UninstallService(


                $this->getRepositoryProvider()->getApiAccessRepository()


            );


        }





        return $instance;


    }





    public function getRepositoryProvider(): RepositoryProvider


    {


        static $instance;


        if (!isset($instance)) {


            $instance = new RepositoryProvider($this->container);


        }





        return $instance;


    }





    public function getApiClient(): ?ApiClient


    {


        static $instance;





        if (!isset($instance)) {


            $apiAccess = $this->getRepositoryProvider()->getApiAccessRepository()->load();





            if (!$apiAccess) {


                return null;


            }





            $instance = ApiClientFactory::createDefault($apiAccess->getApiId(),  $apiAccess->getApiSecret(), $this->getLogger());


        }





        return $instance;


     }





     private function getLogger(): LoggerInterface


     {


         static $logger;





         if (isset($logger)) {


             return $logger;


         }





        $logger = new Logger(


            'apaczka',


            [


                new StreamHandler(


                    dirname(__FILE__, 3


                    ) . sprintf('/var/logs/apaczka_%s.log', date("Y-m-d")),


                    Logger::DEBUG


                )


            ]


        );





         return $logger;


     }





    private function getModuleConfig(): ModuleConfigInterface


    {


        static $instance;


        if (!isset($instance)) {


            $instance = new ModuleConfig();


        }





        return $instance;


    }





    public function getTemplating(): TwigEngine


    {


        return $this->container->get('templating');


    }





}