<?php





declare(strict_types=1);





namespace Apaczka\Prestashop\Provider;





use Symfony\Component\DependencyInjection\ContainerInterface;


use Symfony\Component\Routing\RouterInterface;


use PrestaShop\PrestaShop\Adapter\SymfonyContainer;





class RouteProvider


{


    private const ROUTE_SETTINGS = 'apaczka_settings';





    private static self $instance;


    private RouterInterface $router;





    public function __construct(ContainerInterface $container)


    {


        $this->router = $container->get('router');


    }





    public static function getInstance(): self


    {


        if (!isset(self::$instance)) {


            self::$instance = new self(SymfonyContainer::getInstance());


        }





        return self::$instance;


    }





    public function getSettingsUrl(): string


    {


        return $this->router->generate(self::ROUTE_SETTINGS);


    }


}