<?php





declare(strict_types=1);





namespace Apaczka\Prestashop\Provider;





use Apaczka\Prestashop\Model\ApiAccessRepositoryInterface;


use Apaczka\Prestashop\Model\SenderRepositoryInterface;


use Symfony\Component\DependencyInjection\ContainerInterface;





class RepositoryProvider


{


    private ContainerInterface $container;





    /**


     * @param ContainerInterface $container


     */


    public function __construct(ContainerInterface $container)


    {


        $this->container = $container;


    }





    public function getApiAccessRepository(): ApiAccessRepositoryInterface


    {


        return $this->container->get(ApiAccessRepositoryInterface::class);


    }





    public function getSenderRepository(): SenderRepositoryInterface


    {


        return $this->container->get(SenderRepositoryInterface::class);


    }


}