<?php





declare(strict_types=1);





namespace Apaczka\Prestashop\Provider;





use Apaczka\Api\Client\Model\PackageType;





class PackageTypesProvider


{


    private ApiClientProvider $apiClientProvider;





    public function  __construct(ApiClientProvider $apiClientProvider)


    {


        $this->apiClientProvider = $apiClientProvider;


    }





    /**


     * @return array<string, string>


     */


    public function getOptions(): array


    {


        $types = $this->apiClientProvider->getClient()->getServiceStructure()->getPackageTypes();


        $options = [];





        /**


         * @var $type PackageType


         */


        foreach ($types as $type) {


            $options[(string) $type->getType()] = $type->getDescription();


        }





        return $options;


    }


}