<?php





declare(strict_types=1);





namespace Apaczka\Prestashop\Provider;





use Apaczka\Api\Client\ApiClient;


use RuntimeException;





class ApiClientProvider


{


    private ServiceProvider $serviceProvider;





    public function __construct(ServiceProvider $serviceProvider)


    {


        $this->serviceProvider = $serviceProvider;


    }





    public function getClient(): ApiClient


    {


        $client = $this->serviceProvider->getApiClient();





        if (null === $client) {


            throw new RuntimeException('Unable to create api client');


        }





        return $client;


    }


}