<?php





declare(strict_types=1);





namespace Apaczka\Prestashop\Model;


use Apaczka\Api\Client\Model\PickupTypeEnum;


use Apaczka\Api\Client\Model\PointTypeEnum;


use Serializable;





class SendingPoints implements Serializable


{


    private ?SendingPoint $inPost = null;


    private ?SendingPoint $dhl = null;


    private ?SendingPoint $orlenPaczka = null;


    private ?SendingPoint $pocztaPolska = null;


    private ?SendingPoint $dpd = null;


    private ?SendingPoint $ups = null;





    public function getInPost(): ?SendingPoint


    {


        return $this->inPost;


    }





    public function setInPost(SendingPoint $inPost): void


    {


        $this->inPost = $inPost;


    }





    public function getDhl(): ?SendingPoint


    {


        return $this->dhl;


    }





    public function setDhl(SendingPoint $dhl): void


    {


        $this->dhl = $dhl;


    }





    public function getOrlenPaczka(): ?SendingPoint


    {


        return $this->orlenPaczka;


    }





    public function setOrlenPaczka(SendingPoint $orlenPaczka): void


    {


        $this->orlenPaczka = $orlenPaczka;


    }





    public function getPocztaPolska(): ?SendingPoint


    {


        return $this->pocztaPolska;


    }





    public function setPocztaPolska(SendingPoint $pocztaPolska): void


    {


        $this->pocztaPolska = $pocztaPolska;


    }





    public function getDpd(): ?SendingPoint


    {


        return $this->dpd;


    }





    public function setDpd(SendingPoint $dpd): void


    {


        $this->dpd = $dpd;


    }





    public function getUps(): ?SendingPoint


    {


        return $this->ups;


    }





    public function setUps(SendingPoint $ups): void


    {


        $this->ups = $ups;


    }





    public function toArray(): array


    {


        return [


            PointTypeEnum::INPOST => $this->inPost ? $this->inPost->toArray() : null,


            PointTypeEnum::PWR => $this->orlenPaczka ? $this->orlenPaczka->toArray() : null,


            PointTypeEnum::POCZTA  => $this->pocztaPolska ? $this->pocztaPolska->toArray() : null,


            PointTypeEnum::DHL_PARCEL  => $this->dhl ? $this->dhl->toArray() : null,


            PointTypeEnum::DHL => $this->dhl ? $this->dhl->toArray() : null,


            PointTypeEnum::DPD => $this->dpd ? $this->dpd->toArray() : null,


            PointTypeEnum::UPS  => $this->ups ? $this->ups->toArray() : null,


        ];


    }





    public function __serialize(): array


    {


        return [


            PointTypeEnum::INPOST => serialize($this->inPost),


            PointTypeEnum::PWR => serialize($this->orlenPaczka),


            PointTypeEnum::POCZTA => serialize($this->pocztaPolska),


            PointTypeEnum::DHL_PARCEL => serialize($this->dhl),


            PointTypeEnum::DPD => serialize($this->dpd),


            PointTypeEnum::UPS => serialize($this->ups),


        ];


    }





    public function __unserialize(array $data): void


    {


        $this->inPost = unserialize($data[PointTypeEnum::INPOST] ?? $data[0]);


        $this->orlenPaczka = unserialize($data[PointTypeEnum::PWR] ?? $data[1]);


        $this->pocztaPolska = unserialize($data[PointTypeEnum::POCZTA] ?? $data[2]);


        $this->dhl = unserialize($data[PointTypeEnum::DHL_PARCEL] ?? $data[3]);


        $this->dpd = unserialize($data[PointTypeEnum::DPD] ?? $data[4]);


        $this->ups = unserialize($data[PointTypeEnum::UPS] ?? $data[5]);


    }





    public function serialize(): string


    {


        return serialize($this->__serialize());


    }





    public function unserialize($data):  void


    {


        $this->__unserialize(unserialize($data));


    }


}