<?php





declare(strict_types=1);





namespace Apaczka\Prestashop\Model;


use Serializable;





class SendingPoint  implements Serializable


{


    private string $identity;


    private string $addressFirstLine;


    private string $addressSecondLine;


    private ?string $name = null;





    /**


     * @return string


     */


    public function getIdentity(): string


    {


        return $this->identity;


    }





    /**


     * @param string $identity


     */


    public function setIdentity(string $identity): void


    {


        $this->identity = $identity;


    }





    /**


     * @return string


     */


    public function getAddressFirstLine(): string


    {


        return $this->addressFirstLine;


    }





    /**


     * @param string $addressFirstLine


     */


    public function setAddressFirstLine(string $addressFirstLine): void


    {


        $this->addressFirstLine = $addressFirstLine;


    }





    /**


     * @return string


     */


    public function getAddressSecondLine(): string


    {


        return $this->addressSecondLine;


    }





    /**


     * @param string $addressSecondLine


     */


    public function setAddressSecondLine(string $addressSecondLine): void


    {


        $this->addressSecondLine = $addressSecondLine;


    }





    /**


     * @return string|null


     */


    public function getName(): ?string


    {


        return $this->name;


    }





    /**


     * @param string|null $name


     */


    public function setName(?string $name): void


    {


        $this->name = $name;


    }





    public function toArray(): array


    {


        return [


            'identity' => $this->identity,


            'addressFirstLine' => $this->addressFirstLine,


            'addressSecondLine' => $this->addressSecondLine,


            'name' => $this->name,


        ];


    }





    public function __serialize(): array


    {


        return $this->toArray();


    }





    public function __unserialize(array $data): void


    {


         $this->identity = $data['identity'] ?? $data[0];


         $this->addressFirstLine = $data['addressFirstLine'] ?? $data[1];


         $this->addressSecondLine = $data['addressSecondLine'] ?? $data[2];


         $this->name = $data['name'] ?? $data[3];


    }





    public function serialize(): string


    {


       return serialize($this->__serialize());


    }





    public function unserialize($data):  void


    {


        $this->__unserialize(unserialize($data));


    }


}