<?php





declare(strict_types=1);





namespace Apaczka\Prestashop\Model;





use Apaczka\Prestashop\Entity\ApaczkaSender;





interface SenderRepositoryInterface


{


    public function get(int $id): ?ApaczkaSender;





    public function getDefault(): ?ApaczkaSender;





    public function add(ApaczkaSender $sender): void;





    public function remove(ApaczkaSender $sender): void;





    /**


     * @return iterable<ApaczkaSender>


     */


    public function list(array $filters = [], array $orders = []): iterable;





    public function count(array $filters = []): int;


}