<?php





declare(strict_types=1);





namespace Apaczka\Prestashop\Model;





use Serializable;





class PickupHours implements Serializable


{


    private ?string $from = null;





    private ?string $to  = null;





    public function getFrom(): ?string


    {


        return $this->from;


    }





    public function setFrom(string $from): void


    {


        $this->from = $from;


    }





    public function getTo(): ?string


    {


        return $this->to;


    }





    public function setTo(string $to): void


    {


        $this->to = $to;


    }





    public function __serialize(): array


    {


        return [


            'from' => $this->from,


            'to' => $this->to,


        ];


    }





    public function __unserialize(array $data): void


    {


        $this->from = $data['from'] ?? $data[0] ?? null;


        $this->to = $data['to'] ?? $data[1] ?? null;


    }





    public function serialize(): string


    {


        return serialize($this->__serialize());


    }





    public function unserialize($data):  void


    {


        $this->__unserialize(unserialize($data));


    }


}