<?php





declare(strict_types=1);





namespace Apaczka\Prestashop\Model;





use Apaczka\Prestashop\Entity\ApaczkaPackage;








interface PackageRepositoryInterface


{


    public function get(int $id): ?ApaczkaPackage;





    public function getDefault(): ?ApaczkaPackage;





    public function add(ApaczkaPackage $package): void;





    public function remove(ApaczkaPackage $package): void;





    /**


     * @return iterable<ApaczkaPackage>


     */


    public function list(array $filters = [], array $orders = []): iterable;





    /**


     * @return array<string, string>


     */


    public function getTypeOptions(): array;





    public function count(array $filters = []): int;


}