<?php





declare(strict_types=1);





namespace Apaczka\Prestashop\Model;





class ApiAccess


{


    private string $apiId;


    private string $apiSecret;





    private function __construct(string $apiId, string $apiSecret)


    {


        $this->apiId = $apiId;


        $this->apiSecret = $apiSecret;


    }





    public static function create(string $apiId, string $apiSecret): self


    {


        return new self( $apiId,  $apiSecret);


    }





    public static function restore(string $apiId, string $apiSecret): self


    {


        return new self($apiId,  $apiSecret);


    }





    public function getApiId(): string


    {


        return $this->apiId;


    }





    public function getApiSecret(): string


    {


        return $this->apiSecret;


    }





    public function changeApiId(string $id): void


    {


        $this->apiId = $id;


    }





    public function changeApiSecret(string $secret): void


    {


        $this->apiSecret = $secret;


    }





}