<?php





declare(strict_types=1);





namespace Apaczka\Prestashop\Form\Admin;





use Apaczka\Api\Client\Model\PointTypeEnum;


use Apaczka\Prestashop\Model\SendingPoints;


use Symfony\Component\Form\AbstractType;


use Symfony\Component\Form\FormBuilderInterface;


use Symfony\Component\OptionsResolver\OptionsResolver;





class SettingsSendingPointsForm extends AbstractType


{


    private const TRANSLATION_DOMAIN = 'Modules.Apaczkashipments.Admin';





    public function buildForm(FormBuilderInterface $builder, array $options)


    {


        $builder


            ->add(


            'inPost',


            SettingsSendingPointForm::class,


                [


                    'required' => false,


                    'label' => 'InPost',


                    'supplier_id' => PointTypeEnum::INPOST


                ]


            )


            ->add(


                'dhl',


                SettingsSendingPointForm::class,


                [


                    'required' => false,


                    'label' => 'DHL',


                    'supplier_id' => PointTypeEnum::DHL_PARCEL


                ]


            )


            ->add(


                'orlenPaczka',


                SettingsSendingPointForm::class,


                [


                    'required' => false,


                    'label' => 'ORLEN Paczka',


                    'supplier_id' => PointTypeEnum::PWR


                ]


            )


            ->add(


                'pocztaPolska',


                SettingsSendingPointForm::class,


                [


                    'required' => false,


                    'label' => 'Poczta Polska',


                    'supplier_id' => PointTypeEnum::POCZTA


                ]


            )


            ->add(


                'dpd',


                SettingsSendingPointForm::class,


                [


                    'required' => false,


                    'label' => 'DPD',


                    'supplier_id' => PointTypeEnum::DPD


                ]


            )


            ->add(


                'ups',


                SettingsSendingPointForm::class,


                [


                    'required' => false,


                    'label' => 'UPS',


                    'supplier_id' => PointTypeEnum::UPS


                ]


            )


        ;


    }





    public function configureOptions(OptionsResolver $resolver)


    {


        $resolver->setDefaults([


            'data_class' => SendingPoints::class


        ]);


    }


}