<?php





declare(strict_types=1);





namespace Apaczka\Prestashop\Form\Admin;





use Apaczka\Prestashop\Model\SendingPoint;


use Symfony\Component\Form\AbstractType;


use Symfony\Component\Form\FormBuilderInterface;


use Symfony\Component\Form\Extension\Core\Type as FormFieldType;


use Symfony\Component\OptionsResolver\OptionsResolver;





class SettingsSendingPointForm extends AbstractType


{


    private const TRANSLATION_DOMAIN = 'Modules.Apaczkashipments.Admin';





    public function buildForm(FormBuilderInterface $builder, array $options)


    {


        $builder


            ->add(


                'identity', FormFieldType\TextType::class,


                [


                    'label' => false,


                    'attr' => [


                        'class' => 'apaczka-map-combo',


                        'data-supplier' => $options['supplier_id']


                    ]


                ]


            )


            ->add(


                'name', FormFieldType\HiddenType::class,


                [


                    'label' => false,


                    'attr' => [


                        'class' => 'apaczka-point-name',


                    ]


                ]


            )


            ->add(


                'address_first_line', FormFieldType\HiddenType::class,


                [


                    'label' => false,


                    'attr' => [


                        'class' => 'apaczka-point-address-first',


                    ]


                ]


            )


            ->add(


                'address_second_line', FormFieldType\HiddenType::class,


                [


                    'label' => false,


                    'attr' => [


                        'class' => 'apaczka-point-address-second',


                    ]


                ]


            );


    }





    public function configureOptions(OptionsResolver $resolver)


    {


        $resolver->setDefaults([


            'data_class' => SendingPoint::class


        ]);





        $resolver->setRequired(['supplier_id']);


        $resolver->setAllowedTypes('supplier_id', 'string');


    }


}