<?php





declare(strict_types=1);





namespace Apaczka\Prestashop\Form\Admin;





use Apaczka\Prestashop\Entity\ApaczkaPackage;


use Symfony\Component\Form\AbstractType;


use Symfony\Component\Form\FormBuilderInterface;


use Symfony\Component\Form\Extension\Core\Type as FormFieldType;


use Symfony\Component\OptionsResolver\OptionsResolver;


use Symfony\Component\Validator\Constraints as Assert;





class PackageForm extends AbstractType


{


    private const TRANSLATION_DOMAIN = 'Modules.Apaczkashipments.Admin';





    public function buildForm(FormBuilderInterface $builder, array $options)


    {


        if (false === $options['disableSwitchService']) {


            $builder


                ->add('service', FormFieldType\ChoiceType::class, [


                    'choices' => $options['servicesChoices'],


                    'label' => 'package.service.label',


                    'placeholder' => 'package.service.placeholder',


                    'translation_domain' => self::TRANSLATION_DOMAIN,


                    'multiple' => false,


                    'expanded' => false,


                    'required' => true,


                    'constraints' => [


                        new Assert\NotBlank(),


                    ]


                ]);


        }





        $builder->


            add('type', FormFieldType\ChoiceType::class, [


                'choices' => $options['typesChoices'],


                'label' => 'package.type.label',


                'placeholder' => 'package.type.placeholder',


                'translation_domain' => self::TRANSLATION_DOMAIN,


                'attr' => [


                    'class' => 'apaczka-package-type',


                    'data-length' => '.apaczka-package-length',


                    'data-width' => '.apaczka-package-width',


                    'data-height' => '.apaczka-package-height',


                    'data-weight' => '.apaczka-package-weight',


                ],


                'multiple' => false,


                'expanded' => false,


                'required' => true,


                'constraints' => [


                    new Assert\NotBlank(),


                ]


            ]);





            $builder->add('length', FormFieldType\IntegerType::class, [


                'required' => true,


                'label' => 'package.length.label',


                'translation_domain' => self::TRANSLATION_DOMAIN,


                'attr' => [


                    'maxlength' => 3,


                    'class' => 'apaczka-package-length',


                ],


                'constraints' => [


                    new Assert\NotBlank(),


                    new Assert\GreaterThanOrEqual([


                        'value' => 0,


                    ]),


                    new Assert\LessThanOrEqual([


                        'value' => 999,


                    ]),


                ]


            ])


            ->add('width', FormFieldType\IntegerType::class, [


                'required' => true,


                'label' => 'package.width.label',


                'translation_domain' => self::TRANSLATION_DOMAIN,


                'attr' => [


                    'maxlength' => 3,


                    'class' => 'apaczka-package-width',


                ],


                'constraints' => [


                    new Assert\NotBlank(),


                    new Assert\GreaterThanOrEqual([


                        'value' => 0,


                    ]),


                    new Assert\LessThanOrEqual([


                        'value' => 999,


                    ]),


                ]


            ])


            ->add('height', FormFieldType\IntegerType::class, [


                'required' => true,


                'label' => 'package.height.label',


                'translation_domain' => self::TRANSLATION_DOMAIN,


                'attr' => [


                    'maxlength' => 3,


                    'class' => 'apaczka-package-height',


                ],


                'constraints' => [


                    new Assert\NotBlank(),


                    new Assert\GreaterThanOrEqual([


                        'value' => 0,


                    ]),


                    new Assert\LessThanOrEqual([


                        'value' => 999,


                    ]),


                ]


            ])


            ->add('weight', FormFieldType\IntegerType::class, [


                'required' => true,


                'label' => 'package.weight.label',


                'translation_domain' => self::TRANSLATION_DOMAIN,


                'attr' => [


                    'maxlength' => 4,


                    'class' => 'apaczka-package-weight',


                ],


                'constraints' => [


                    new Assert\NotBlank(),


                    new Assert\GreaterThanOrEqual([


                        'value' => 0,


                    ]),


                    new Assert\LessThanOrEqual([


                        'value' => 9999,


                    ]),


                ]


            ])


            ->add('content', FormFieldType\TextType::class, [


                'required' => $options['requireContent'],


                'label' => 'package.content.label',


                'translation_domain' => self::TRANSLATION_DOMAIN,


                'attr' => [


                    'maxlength' => 255


                ],


                'constraints' => [


                    new Assert\Length(['max' => 255]),


                ]


            ])


            ->add('outOfStandard', FormFieldType\CheckboxType::class, [


                    'required' => false,


                    'label' => 'package.out_of_standard.label',


                    'translation_domain' => self::TRANSLATION_DOMAIN,


            ]);





            if ($options['addTemplateName']) {


                $builder->add("templateName", FormFieldType\TextType::class, [


                    'required' => false,


                    'label' => false,


                    'attr' => [


                        'maxlength' => 50,


                        'class' => 'apaczka-template-package-name'


                    ]


                ]);


            }


    }





    public function configureOptions(OptionsResolver $resolver)


    {


        $resolver->setDefaults([


            'data_class' => ApaczkaPackage::class,


            'addTemplateName' => true,


            'requireContent' => false,


            'disableSwitchService' => false,


        ]);





        $resolver->setRequired([


            'servicesChoices',


            'typesChoices',


        ]);


        $resolver->setAllowedTypes('servicesChoices', 'array');


        $resolver->setAllowedTypes('typesChoices', 'array');


        $resolver->setAllowedTypes('addTemplateName', 'bool');


        $resolver->setAllowedTypes('requireContent', 'bool');


        $resolver->setAllowedTypes('disableSwitchService', 'bool');


    }


}