<?php





declare(strict_types=1);





namespace Apaczka\Prestashop\Entity;





use Doctrine\ORM\Mapping as ORM;





/**


 * @ORM\Table()


 * @ORM\Entity(repositoryClass="Apaczka\Prestashop\Repository\Doctrine\OrderRepository")


 */


class ApaczkaOrder


{


    /**


     * @ORM\Id


     * @ORM\Column(name="id", type="integer")


     * @ORM\GeneratedValue(strategy="AUTO")


     */


    private ?int $id;





    /**


     * @ORM\Column(name="ps_order_id", type="integer", nullable=false)


     */


    private int $psOrderId;





    /**


     * @ORM\Column(name="apaczka_order_id", type="string", nullable=false, length=50)


     */


    private string $apaczkaOrderId;





    /**


     * @return int|null


     */


    public function getId(): ?int


    {


        return $this->id;


    }





    /**


     * @param int|null $id


     */


    public function setId(?int $id): void


    {


        $this->id = $id;


    }





    /**


     * @return int


     */


    public function getPsOrderId(): int


    {


        return $this->psOrderId;


    }





    /**


     * @param int $psOrderId


     */


    public function setPsOrderId(int $psOrderId): void


    {


        $this->psOrderId = $psOrderId;


    }





    /**


     * @return string


     */


    public function getApaczkaOrderId(): string


    {


        return $this->apaczkaOrderId;


    }





    /**


     * @param string $apaczkaOrderId


     */


    public function setApaczkaOrderId(string $apaczkaOrderId): void


    {


        $this->apaczkaOrderId = $apaczkaOrderId;


    }


}