<?php





declare(strict_types=1);





namespace Apaczka\Prestashop\Controller\Admin;





use Apaczka\Prestashop\Entity\ApaczkaSender;


use Apaczka\Prestashop\Form\Admin\SettingsApiAccessForm;


use Apaczka\Prestashop\Form\Admin\SettingsForm;


use Apaczka\Prestashop\Model\ApiAccess;


use Apaczka\Prestashop\Model\ApiAccessRepositoryInterface;


use Apaczka\Prestashop\Model\PackageRepositoryInterface;


use Apaczka\Prestashop\Model\PickupHoursRepositoryInterface;


use Apaczka\Prestashop\Model\SenderRepositoryInterface;


use Apaczka\Prestashop\Model\SendingPointsRepositoryInterface;


use Apaczka\Prestashop\Model\ServicesRepositoryInterface;


use Apaczka\Prestashop\Provider\ServiceProvider;


use Apaczka\Prestashop\Service\ValidateApiAccessDataService;


use PrestaShopBundle\Controller\Admin\FrameworkBundleAdminController;


use Symfony\Component\HttpFoundation\JsonResponse;


use Symfony\Component\HttpFoundation\Request;


use Symfony\Component\HttpFoundation\Response;





class SettingsController extends FrameworkBundleAdminController


{


    protected const TPL_DIR = '@Modules/apaczkashipments/views/templates/admin/';


    private ApiAccessRepositoryInterface $apiAccessRepository;


    private SenderRepositoryInterface $senderRepository;


    private ServiceProvider $serviceProvider;


    private ServicesRepositoryInterface $servicesRepository;


    private PackageRepositoryInterface $packageRepository;


    private SendingPointsRepositoryInterface $sendingPointsRepository;


    private PickupHoursRepositoryInterface $pickupHoursRepository;


    private ValidateApiAccessDataService $apiAccessDataService;





    use SettingControllerTrait;





    public function __construct(


        ApiAccessRepositoryInterface $apiAccessRepository,


        SenderRepositoryInterface $senderRepository,


        ServicesRepositoryInterface $servicesRepository,


        PackageRepositoryInterface $packageRepository,


        SendingPointsRepositoryInterface $sendingPointsRepository,


        PickupHoursRepositoryInterface $pickupHoursRepository,


        ServiceProvider $serviceProvider,


        ValidateApiAccessDataService $apiAccessDataService)


    {


        $this->apiAccessRepository = $apiAccessRepository;


        $this->senderRepository = $senderRepository;


        $this->serviceProvider = $serviceProvider;


        $this->servicesRepository = $servicesRepository;


        $this->packageRepository = $packageRepository;


        $this->sendingPointsRepository = $sendingPointsRepository;


        $this->pickupHoursRepository = $pickupHoursRepository;


        $this->apiAccessDataService = $apiAccessDataService;


    }





    public function index(Request $request): Response


    {


        return $this->render(self::TPL_DIR . 'settings/index.html.twig');


    }





    public function apiAccess(Request $request): Response


    {


        $saved = false;


        $template = self::TPL_DIR . 'settings/form/api_access.html.twig';


        $apiAccess = $this->apiAccessRepository->load();





        $form =  $this->createForm(SettingsApiAccessForm::class, null === $apiAccess ? null : [


            'api_id' => $apiAccess->getApiId(),


            'api_secret' => $apiAccess->getApiSecret(),


        ]);





        $form->handleRequest($request);





        if (!$form->isSubmitted()) {


            return $this->render($template, [


                'form' => $form->createView(),


                'show_api_access_invalid_error' => null !== $apiAccess && !$this->apiAccessDataService->isValidApiAccess($apiAccess)


            ]);


        }





        if ($form->isValid()) {


            if (null === $apiAccess) {


                $apiAccess = ApiAccess::create(


                    $form->get('api_id')->getData(),


                    $form->get('api_secret')->getData()


                );


            } else {


                $apiAccess->changeApiId($form->get('api_id')->getData());


                $apiAccess->changeApiSecret($form->get('api_secret')->getData());


            }





            if ($this->apiAccessDataService->isValidApiAccess($apiAccess)) {


                $this->apiAccessRepository->save($apiAccess);


                $saved = true;


            }


        }





        return new JsonResponse([


            'content' => $this->renderView($template, ['form' => $form->createView(), 'saved' => $saved, 'show_api_access_invalid_error' => null !== $apiAccess && !$this->apiAccessDataService->isValidApiAccess($apiAccess)]),


            'reloadPage' => $saved,


        ]);


    }





    public function validateApiAccess(Request $request): JsonResponse


    {


        return new JsonResponse(['valid' => $this->apiAccessDataService->isValidAccess(


            $request->get('api_id', null),


            $request->get('api_secret', null),


        )]);





    }


    public function settings(Request $request): Response


    {


        $apiAccess = $this->apiAccessRepository->load();


        if (null === $apiAccess || !$this->apiAccessDataService->isValidApiAccess($apiAccess)) {


            return new Response();


        }





        $saved = false;


        $template = self::TPL_DIR . 'settings/form/settings.html.twig';


        $sender = $this->senderRepository->getDefault();


        $package = $this->packageRepository->getDefault();


        $refreshServices = (bool) $request->get('refresh_services', false);


        $services = $this->servicesRepository->getOptions(!$refreshServices);


        $points = $this->sendingPointsRepository->get();


        $pickupHours = $this->pickupHoursRepository->get();


        $sendersList = $this->senderRepository->list(['isDefault' => false]);


        $packagesList = $this->packageRepository->list(['isDefault' => false]);


        $hasSender = null !== $sender;


        $hasPackage = null !== $package;





        $this->packageRepository->getTypeOptions();





        $form = $this->createForm(SettingsForm::class, [


            'sender' => $sender,


            'services' => $this->servicesRepository->getChosen(),


            'package' => $package,


            'points' => $points,


            'pickup_hours' => $pickupHours,


            ], [


                'servicesChoices' => array_flip($services),


                'servicesChosenChoices' => array_flip($this->servicesRepository->getChosenOptions()),


                'packageTypesChoices' => array_flip($this->packageRepository->getTypeOptions())


            ]);





        $form->handleRequest($request);





        $viewParams = [


            'form' => $form->createView(),


            'apaczkaMapAppId' => $apiAccess->getApiId(),


            'sendersList' => $sendersList,


            'packagesList' => $packagesList,


            'hasSender' => $hasSender,


            'hasPackage' => $hasPackage,


        ];





        if ($refreshServices) {


            return new JsonResponse([


                'content' => $this->renderView($template, $viewParams),


            ]);


        }





        if (!$form->isSubmitted()) {


            return $this->render($template, $viewParams);


        }





        if ($form->isValid()) {


            /**


             * @var ApaczkaSender $sender


             */


            $sender = $form->get('sender')->getData();


            $sender->setIsDefault(true);


            $sender->setTemplateName(null);


            $package = $form->get('package')->getData();


            $package->setIsDefault(true);


            $package->setTemplateName(null);


            $this->senderRepository->add($sender);


            $this->packageRepository->add($package);


            $this->servicesRepository->saveChosen($form->get('services')->getData());


            $this->sendingPointsRepository->save($form->get('points')->getData());


            $this->pickupHoursRepository->save($form->get('pickup_hours')->getData());


            $saved = true;


        }





        return new JsonResponse([


            'content' => $this->renderView(


                $template,


                array_merge(


                    $viewParams,


                    [


                        'form' => $form->createView(),


                        'saved' => $saved,


                        'hasSender' => null !== $sender,


                        'hasPackage' => null !== $package,


                    ]


                )


            ),


            'saved' => $saved


        ]);


    }


}