<?php





declare(strict_types=1);





namespace Apaczka\Prestashop\Controller\Admin;





use Apaczka\Prestashop\Form\Admin\SenderForm;


use Apaczka\Prestashop\Model\SenderRepositoryInterface;


use PrestaShopBundle\Controller\Admin\FrameworkBundleAdminController;


use Symfony\Component\HttpFoundation\JsonResponse;


use Symfony\Component\HttpFoundation\Request;


use Symfony\Component\HttpFoundation\Response;





class SenderTemplateController extends FrameworkBundleAdminController


{


    private SenderRepositoryInterface $senderRepository;


    protected const TPL_DIR = '@Modules/apaczkashipments/views/templates/admin/';





    public function __construct(


        SenderRepositoryInterface $senderRepository


    )


    {


        $this->senderRepository = $senderRepository;


    }





    public function save(Request $request): Response


    {


        $template = self::TPL_DIR . 'settings/form/settings_sender.html.twig';


        $form =  $this->createForm(SenderForm::class, null, ['csrf_protection' => false]);


        $form->handleRequest($request);


        $saved = false;





        if ($form->isSubmitted() && $form->isValid()) {


            $sender = $form->getData();


            $sender->setIsDefault(false);


            $this->senderRepository->add($sender);


            $saved = true;


        }





        return new JsonResponse([


            'content' => $this->renderView($template, [


                'form' => $form->createView(),


                'templateSaved' => $saved,


                'hasSender' => true,


            ]),


            'saved' => $saved


        ]);


    }





    public function delete(Request $request, int $id): Response


    {


        $sender = $this->senderRepository->get($id);





        if (null !== $sender && !$sender->isDefault()) {


            $this->senderRepository->remove($sender);


        }





        return new JsonResponse(['deleted' => true, 'templateId' => $id]);


    }





    public function list(Request $request): Response


    {


        $template = self::TPL_DIR . 'sender_template/list.html.twig';


        $senders = $this->senderRepository->list(['isDefault' => false]);





        return new JsonResponse(['content' => $this->renderView($template, ['senders'=> $senders])]);


    }


}