<?php















declare(strict_types=1);















namespace Apaczka\Prestashop\Controller\Admin;















use Apaczka\Api\Client\Common\CollectionInterface;







use Apaczka\Api\Client\Model\OrderStatusEnum;







use Apaczka\Api\Client\Model\PickupTypeEnum;







use Apaczka\Api\Client\Model\Shipment;







use Apaczka\Prestashop\Entity\ApaczkaOrder;







use Apaczka\Prestashop\Entity\ApaczkaPackage;







use Apaczka\Prestashop\Entity\ApaczkaSender;







use Apaczka\Prestashop\Form\Admin\OrderForm;







use Apaczka\Prestashop\Helper\CodHelper;







use Apaczka\Prestashop\Model\OrderRepositoryInterface;







use Apaczka\Prestashop\Model\PackageRepositoryInterface;







use Apaczka\Prestashop\Model\PickupHoursRepositoryInterface;







use Apaczka\Prestashop\Model\SenderRepositoryInterface;







use Apaczka\Prestashop\Model\SendingPointsRepositoryInterface;







use Apaczka\Prestashop\Model\ServicesRepositoryInterface;







use Apaczka\Prestashop\Provider\ServiceProvider;







use Apaczka\Prestashop\Service\MapOrderedPointService;







use Exception;







use PrestaShopBundle\Controller\Admin\FrameworkBundleAdminController;







use PrestaShopBundle\Translation\TranslatorInterface;







use Symfony\Component\HttpFoundation\JsonResponse;







use Symfony\Component\HttpFoundation\RedirectResponse;







use Symfony\Component\HttpFoundation\Request;







use Symfony\Component\HttpFoundation\Response;







use Symfony\Component\Form\FormError;







use OrderCore as PrestaShopOrder;







use AddressCore as PrestaShopAddress;







use CustomerCore as PrestaShopCustomer;







use Apaczka\Api\Client\Model as ApiModel;







use Throwable;















class OrderController extends FrameworkBundleAdminController







{







    protected const TPL_DIR = '@Modules/apaczkashipments/views/templates/admin/order/';







    private const TRANSLATION_DOMAIN = 'Modules.Apaczkashipments.Admin';















    private SenderRepositoryInterface $senderRepository;







    private ServicesRepositoryInterface $servicesRepository;







    private PackageRepositoryInterface $packageRepository;







    private PickupHoursRepositoryInterface $pickupHoursRepository;







    private ServiceProvider $serviceProvider;







    private SendingPointsRepositoryInterface $sendingPointsRepository;







    private OrderRepositoryInterface $orderRepository;







    private MapOrderedPointService $mapOrderedPointService;







    private CodHelper $codHelper;















    public function __construct(







        SenderRepositoryInterface $senderRepository,







        ServicesRepositoryInterface $servicesRepository,







        PackageRepositoryInterface $packageRepository,







        PickupHoursRepositoryInterface $pickupHoursRepository,







        SendingPointsRepositoryInterface $sendingPointsRepository,







        OrderRepositoryInterface $orderRepository,







        MapOrderedPointService $mapOrderedPointService,







        ServiceProvider $serviceProvider,







        CodHelper $codHelper







    )







    {







        $this->senderRepository = $senderRepository;







        $this->servicesRepository = $servicesRepository;







        $this->packageRepository = $packageRepository;







        $this->pickupHoursRepository = $pickupHoursRepository;







        $this->serviceProvider = $serviceProvider;







        $this->sendingPointsRepository = $sendingPointsRepository;







        $this->orderRepository = $orderRepository;







        $this->mapOrderedPointService = $mapOrderedPointService;







        $this->codHelper = $codHelper;







    }















    public function index(Request $request, int $id): Response







    {







         $apaczkaOrder = $this->orderRepository->getByPsOrderId($id);;















         if (null !== $apaczkaOrder) {







             return $this->details($request, $id);







         }















         return $this->manage($request, $id);







    }















    public function details(Request $request, int $id): Response







    {







        $template = self::TPL_DIR . 'details.html.twig';







        $apaczkaOrder = $this->orderRepository->getByPsOrderId($id);







        $apiClient = $this->serviceProvider->getApiClient();















        $apiOrder = $apiClient->getOrder($apaczkaOrder->getApaczkaOrderId());















        $viewParams = [







            'psOrderId' => $id,







            'apiOrder' => $apiOrder,







            'showTurnInButton' => null !== $apiOrder->getPickup() && (string) $apiOrder->getPickup()->getTypeEnum() === PickupTypeEnum::TYPE_COURIER,







        ];















        if ($request->isMethod('post')) {







            return new JsonResponse(['content' =>







                $this->renderView(







                    $template,







                    $viewParams,







                )







            ]);







        }







        return $this->render($template, $viewParams);







    }















    public function manage(Request $request, int $id): Response







    {







        $apiClient = $this->serviceProvider->getApiClient();















        $template = self::TPL_DIR . 'manage.html.twig';







        $shopOrder = new PrestaShopOrder($id);















        $orderedDeliveryPoint = $this->mapOrderedPointService->getOrderedPoint($id);















        $shopDeliveryAddress = new PrestaShopAddress($shopOrder->id_address_delivery);















        $shopCustomer = new PrestaShopCustomer($shopOrder->id_customer);







        $senders = $this->senderRepository->list([], ['isDefault' => 'desc', 'templateName' => 'asc']);







        $sendersChoices = [];







        foreach ($senders as $sender) {







            $sendersChoices[$sender->isDefault() ? 'Default' : $sender->getTemplateName()] = $sender->getId();







        }







        $packages = $this->packageRepository->list([], ['isDefault' => 'desc', 'templateName' => 'asc']);







        $packagesChoices = [];







        foreach ($packages as $package) {







            $packagesChoices[$package->isDefault() ? 'Default' : $package->getTemplateName()] = $package->getId();







        }







        $pickupTypes = $this->serviceProvider->getApiClient()->getServiceStructure()->getPickupTypes();







        $pickupTypesChoices = [];







        foreach ($pickupTypes as $pickupType) {















            if ( (string) $pickupType->getTypeEnum() != "POCZTA" ) {







                







                $pickupTypesChoices[$pickupType->getDescription()] = (string) $pickupType->getTypeEnum();







            }







        }







        $pickupHours = $this->pickupHoursRepository->get();







        $sendingPoints = array_filter($this->sendingPointsRepository->get()->toArray());















        $form = $this->createForm(







            OrderForm::class,







            [







                'senders' => $senders[0]->getId(),







                'sender' => $senders[0],







                'recipient' => [







                    'companyName' => $shopDeliveryAddress->company,







                    'firstname' => $shopDeliveryAddress->firstname,







                    'lastname' => $shopDeliveryAddress->lastname,







                    'street' => $shopDeliveryAddress->address1,







                    'homeNumber' => $shopDeliveryAddress->address2,







                    'flatNumber' => null,







                    'postCode' => $shopDeliveryAddress->postcode,







                    'city' => $shopDeliveryAddress->city,







                    'contactPerson' => $shopDeliveryAddress->firstname . ' ' . $shopDeliveryAddress->lastname ,







                    'phoneNumber' => empty($shopDeliveryAddress->phone_mobile) ? $shopDeliveryAddress->phone : $shopDeliveryAddress->phone_mobile,







                    'email' => $shopCustomer->email,







                ],







                'packages' => $packages[0]->getId(),







                'package' => $packages[0],







                'pickupHours' => $pickupHours,







                'recipientPoint' => is_array($orderedDeliveryPoint) ? $orderedDeliveryPoint['point'] : null,







                'cashOnDelivery' => $this->codHelper->getAmount($shopOrder),







                'shipmentValue' => $this->codHelper->getAmount($shopOrder),







            ],







            [







                'sendersChoices' => $sendersChoices,







                'packagesChoices' => $packagesChoices,







                'pickupTypesChoices' => $pickupTypesChoices,







                'servicesChoices' => array_flip($this->servicesRepository->getChosenOptions()),







                'typesChoices' => array_flip($this->packageRepository->getTypeOptions())







            ]







        );







        $form->handleRequest($request);







        if ($form->getData()['pickupType'] === PickupTypeEnum::TYPE_COURIER && $form->getData()['pickupDate'] === null) {







            $form->get('pickupDate')->addError(new FormError('Data odbioru jest wymagana!'));







        }







        $viewParams = [







            'form' => $form->createView(),







            'senders' => $senders,







            'packages' => $packages,







            'sendingPoints' => $sendingPoints,







            'shopOrderId' => $id,







        ];







        







        if (is_array($orderedDeliveryPoint)) {







            $viewParams['orderedDeliveryPoint'] = $orderedDeliveryPoint;







        }







        







        if (!$form->isSubmitted()) {







            return $this->render(







                $template,







                $viewParams







            );







        }















        if ($form->isValid()) {







            







            $data = $form->getData();







            /**







             * @var $sender ApaczkaSender







             */







            $sender = $data['sender'];







            $receiver = $data['recipient'];







            $pickupHours = $data['pickupHours'];















            if ($data['pickupType'] === PickupTypeEnum::TYPE_COURIER) {







                $form->get('pickupDate')->addError(new FormError('Data odbioru jest wymagana!'));







            }







            /**







             * @var ApaczkaPackage $package







             */







            $package = $data['package'];



            



            $senderAddress =  new ApiModel\Address(







                "PL",







                trim($sender->getFirstname() . ' ' . $sender->getLastname()),







                trim($sender->getStreet() . ' ' . $sender->getHomeNumber() . ( !empty($sender->getFlatNumber()) ?  ' / ' . $sender->getFlatNumber() : '')),







                 null,







                $sender->getPostCode(),







                $sender->getCity(),







                null,







                false,







                $sender->getContactPerson(),







                $sender->getEmail(),







                $sender->getPhoneNumber(),







                $data['senderPoint'],







            );















            $receiverAddress = new ApiModel\Address(







                "PL", // $shopDeliveryAddress->country,







                trim($receiver['firstname'] . ' ' . $receiver['lastname']),







                trim($receiver['street'] . ' ' . $receiver['homeNumber'] . ( !empty($receiver['flatNumber']) ?  ' / ' . $receiver['flatNumber'] : '')),







                null,







                $receiver['postCode'],







                $receiver['city'],







                null,







                false,







                $receiver['contactPerson'],







                $receiver['email'],







                $receiver['phoneNumber'],







                $data['recipientPoint']







            );















            $shipments = new ApiModel\ShipmentCollection(







                new Shipment(







                    new ApiModel\PackageTypeEnum($package->getType()),







                    $package->getWeight(),







                    $package->getLength(),







                    $package->getWidth(),







                    $package->getHeight(),







                    $package->isOutOfStandard(),







                    $package->getContent()







                )







            );















            $price = new ApiModel\Price(







                (int) ($data['shipmentValue'] * 100),







                (int) ($data['shipmentValue'] * 100),







                0







            );















            $pickup = new ApiModel\Pickup(







                new ApiModel\PickupTypeEnum($data['pickupType']),







                $data['pickupDate'],







                null !== $pickupHours ? $pickupHours->getFrom() : null,







                null !== $pickupHours ? $pickupHours->getTo()  : null,







            );















            $isCod = isset( $data['cashOnDelivery']) && $data['cashOnDelivery'] > 0;















            $apiOrder = new ApiModel\Order(







                null,







                !empty($data['serviceId']) ? new ApiModel\Service((int) $data['serviceId']) : null,







                $senderAddress,







                $receiverAddress,







                new ApiModel\OrderStatusEnum(ApiModel\OrderStatusEnum::STATUS_NEW),







                $shipments,







                $price,







                $package->getContent(),







                null,







                null,







                $pickup,







                null,







                null,







                null,







                $isCod,







                 $isCod ? (int) ($data['cashOnDelivery'] * 100) : null,







                $isCod ? $sender->getAccountNumber() : null,







            );















            if (!empty($data['serviceId'])) {







                try {







                    $oldApaczkaOrder = $this->orderRepository->getByPsOrderId($id);







                    if (null !== $oldApaczkaOrder) {







                        $this->orderRepository->remove($oldApaczkaOrder);







                    }















                    $orderCreated = $apiClient->send($apiOrder);















                    $apaczkaOrder = new ApaczkaOrder();







                    $apaczkaOrder->setApaczkaOrderId($orderCreated->getId());







                    $apaczkaOrder->setPsOrderId($id);







                    $this->orderRepository->add($apaczkaOrder);















                    return $this->details($request, $id);















                } catch (Throwable $e) {







                    $viewParams['sendError'] = $e->getMessage() ;







                }







            }















            $apiOrder->unsetService();







            try {







                $prices = $apiClient->getValuation($apiOrder);





                $services = $apiClient->getServiceStructure()->getServices();







                $servicesMap = $this->getAllowedServices($pickup, $services);







                $servicesOptions = $this->servicesRepository->getChosenOptions();



                $viewParams['defaultService'] = $packages[0]->service;



                $newPrices = [];



                foreach ( $prices as $price ) {



                    if ( $price->getServiceId() == $packages[0]->service ) {



                        $newPrices[] = $price;

                    }

                }



                foreach ( $prices as $price ) {



                    if ( $price->getServiceId() != $packages[0]->service ) {



                        $newPrices[] = $price;

                    }

                }



                // echo "<pre>";

                // print_r($newPrices);

                // echo "</pre>";

                // die();



                $viewParams['prices'] = $newPrices;



                $viewParams['servicesOptions'] = $servicesOptions;



                $viewParams['servicesMap'] = $servicesMap;







            } catch (Throwable $e) {







                $viewParams['sendError'] = $e->getMessage() ;







            }







        } else if ($form->isSubmitted()) {







            $viewParams['saved'] = false;







        }















        return new JsonResponse([







            'content' => $this->renderView(







                $template,







                $viewParams,







            ),







        ]);







    }















    /**







     * @param CollectionInterface<ApiModel\Service> $services







     * @return array<ApiModel\Service>







     */







    private function getAllowedServices(ApiModel\Pickup $pickup, CollectionInterface $services): array







    {







        $servicesMap = [];







        switch((string) $pickup->getTypeEnum()) {







            //wyłączony enum



            case PickupTypeEnum::TYPE_POST_OFFICE:







                foreach ($services as $service) {







                    if ($service->isPickupCourier() || $service->isPointToPoint() || $service->isPointToDoor()) {







                        continue;







                    }







                    $servicesMap[$service->getServiceId()] = $service;







                }







                break;



            //wyłączony enum koniec







            case PickupTypeEnum::TYPE_SELF:







                foreach ($services as $service) {







                    if ($service->isPointToPoint() || $service->isPointToDoor() || $service->isPickupCourier() ) {







                        $foundException = 0;







                        $exceptionsDontShow = array(



                            60 => "Pocztex Kurier Drzwi-Drzwi",



                            64 => "Pocztex Kurier Drzwi-Drzwi",



                            //paletowe nie pokazywac



                            250 => "Geodis D2D",



                            260 => "Ambro Express D2D",



                            240 => "Rhenus Logistics D2D",



                            150 => "Geis Cargo D2D", 



                            230 => "Hellmann D2D", 



                            69 => "Poczta Polska Palety D2D", 



                            220 => "Pall-Ex D2D",



                            //warszawka



                            110 => "iPaczka",



                            211 => "Wawa kurier",



                        );







                        foreach ( $exceptionsDontShow as $key => $exception ) {







                            if ( $key == $service->getServiceId() ) {







                                $foundException = 1;



                            }



                        }







                        if ( $foundException == 0 ) {







                            $servicesMap[$service->getServiceId()] = $service;



                        }







                        // echo "<pre>";



                        // print_r($service);



                        // echo "</pre><hr><br>";



                    }



                }







                break;















            case PickupTypeEnum::TYPE_COURIER:







                foreach ($services as $service) {







                    if ( $service->isPickupCourier() ) {







                        $servicesMap[$service->getServiceId()] = $service;







                    }







                }







                break;















            







            default:







                foreach ($services as $service) {







                    $servicesMap[$service->getServiceId()] = $service;







                }







        }







       // var_dump($servicesMap);







        return $servicesMap;







    }















    public function waybill(Request $request, int $id): Response







    {







        $apaczkaOrder = $this->orderRepository->getByPsOrderId($id);







        $apiClient = $this->serviceProvider->getApiClient();















        try {







            $waybill = $apiClient->getWaybill($apaczkaOrder->getApaczkaOrderId());















            if (null === $waybill) {







                throw new Exception('List przewozowy nie jest dostępny');







            }







        } catch (Throwable $e) {







            $this->addFlash('error', $e->getMessage());















            return new RedirectResponse($this->generateUrl('admin_orders_view', ['orderId' => $id]));







        }















        return new Response($waybill->getContent(), Response::HTTP_OK, [







            'Content-Type' => 'application/pdf',







            'Content-Disposition' => 'attachment; filename="waybill_' . $id . date("Y-m-d_his") . '.pdf"',







            'Cache-Control' => 'no-cache, must-revalidate',







            'Expires' => 'Sat, 26 Jul 1997 05:00:00 GMT'







        ]);







    }















    public function turn(Request $request, int $id): Response







    {







        $apaczkaOrder = $this->orderRepository->getByPsOrderId($id);







        $apiClient = $this->serviceProvider->getApiClient();















        try {







            $turnIn = $apiClient->getTurnIn([$apaczkaOrder->getApaczkaOrderId()]);







            if (null === $turnIn) {







                throw new Exception('Protokół nadania nie jest dostępny');







            }







        } catch (Throwable $e){







            $this->addFlash('error', $e->getMessage());















            return new RedirectResponse($this->generateUrl('admin_orders_view', ['orderId' => $id]));







        }















        return new Response($turnIn->getContent(), Response::HTTP_OK, [







            'Content-Type' => 'application/pdf',







            'Content-Disposition' => 'attachment; filename="waybill_' . $id . date("Y-m-d_his") . '.pdf"',







            'Cache-Control' => 'no-cache, must-revalidate',







            'Expires' => 'Sat, 26 Jul 1997 05:00:00 GMT'







        ]);







    }















    public function cancel(Request $request, int $id): Response







    {







        $apaczkaOrder = $this->orderRepository->getByPsOrderId($id);







        $showMessageCancelOnApaczka = false;















        if (null === $apaczkaOrder) {







            return new RedirectResponse($this->generateUrl('admin_orders_view', ['orderId' => $id]));







        }















        try {







            $apiClient = $this->serviceProvider->getApiClient();







            $apiOrder = $apiClient->getOrder($apaczkaOrder->getApaczkaOrderId());















            if ((string) $apiOrder->getStatus() !== OrderStatusEnum::STATUS_CANCELLED) {







                $apiClient->cancelOrder($apaczkaOrder->getApaczkaOrderId());







            }















            $showMessageCancelOnApaczka = mb_strtolower($apiOrder->getService()->getSupplier()) === 'gls';







            if (!$showMessageCancelOnApaczka) {







                /**







                 * @var Shipment $item







                 */







                foreach ($apiOrder->getShipmentCollection()->getIterator() as $item) {







                    if ($item->getPackageTypeEnum()->isPallet()) {







                        $showMessageCancelOnApaczka = true;







                        break;







                    }







                }







            }















            $this->orderRepository->remove($apaczkaOrder);







            if ($showMessageCancelOnApaczka) {







                $this->addFlash('warning', $this->trans('cancel.order.on_apaczka.message', self::TRANSLATION_DOMAIN, []));







            }















        } catch (Throwable $e) {







            $this->addFlash('error', $e->getMessage());







        }















        return new RedirectResponse($this->generateUrl('admin_orders_view', ['orderId' => $id]));







    }







}