<?php





declare(strict_types=1);





namespace Apaczka\Prestashop\Config;








final class ModuleConfig implements ModuleConfigInterface


{


    private const MODULE_NAME = 'apaczkashipments';


    private const MODULE_TAB = 'shipping_logistics';


    private const VERSION = '1.0.0';


    private const PRESTASHOP_SUPPORTED_VERSION_MAX = '1.7.8.10';


    private const PRESTASHOP_SUPPORTED_VERSION_MIN = '1.7.1.0';


    private const AUTHOR = 'Apaczka.pl';


    private const NEED_INSTANCE = false;





    public function getModuleName(): string


    {


        return self::MODULE_NAME;


    }





    public function getModuleTab(): string


    {


        return self::MODULE_TAB;


    }





    public function getModuleAuthor(): string


    {


        return self::AUTHOR;


    }





    public function getModuleVersion(): string


    {


        return self::VERSION;


    }





    public function getMinSupportedPrestashopVersion(): string


    {


        return self::PRESTASHOP_SUPPORTED_VERSION_MIN;


    }





    public function getMaxSupportedPrestashopVersion(): string


    {


        return self::PRESTASHOP_SUPPORTED_VERSION_MAX;


    }





    public function isNeedInstance(): bool


    {


        return self::NEED_INSTANCE;


    }





    public function getModuleDirectory(): string


    {


        return realpath(dirname(__DIR__, 2));


    }


}